/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.worksoft.jenkinsci.plugins.em.EMItemCache;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequest;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public final class ExecuteRequestRequest
extends AbstractDescribableImpl<ExecuteRequestRequest> {
    @Exported
    public String name;

    @DataBoundConstructor
    public ExecuteRequestRequest(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Symbol(value={"emRequest"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecuteRequestRequest> {
        @Nonnull
        public String getDisplayName() {
            return "Execute Request";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            ListBoxModel listBox = EMItemCache.getCachedItems("request");
            FormValidation ret = FormValidation.ok();
            String msg = name;
            if (msg.startsWith("ERROR") || listBox != null && (msg = ((ListBoxModel.Option)listBox.get((int)0)).value).startsWith("ERROR")) {
                ret = FormValidation.error((String)("Execution Manager error retrieving requests - " + msg.replace("ERROR: ", "") + "!"));
            } else if (StringUtils.isEmpty((String)name)) {
                ret = FormValidation.error((String)"A request must be specified!");
            }
            return ret;
        }

        public ListBoxModel doFillNameItems(@RelativePath(value="..") @QueryParameter String requestType, @RelativePath(value="../altEMConfig") @QueryParameter String url, @RelativePath(value="../altEMConfig") @QueryParameter String credentials) {
            return ExecuteRequest.fillItems("request", url, credentials);
        }
    }
}

