/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.worksoft.jenkinsci.plugins.em.model.EmResult;
import com.worksoft.jenkinsci.plugins.em.model.ExecutionManagerServer;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jodd.util.StringUtil;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public final class ExecuteRequestEMConfig
extends AbstractDescribableImpl<ExecuteRequestEMConfig> {
    @Exported
    public String url;
    @Exported
    public String credentials;

    @DataBoundConstructor
    public ExecuteRequestEMConfig(@CheckForNull String url, String credentials) {
        this.url = url;
        this.credentials = credentials;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public boolean isValid() {
        return StringUtil.isNotEmpty((CharSequence)this.url) && StringUtils.isNotEmpty((String)this.credentials);
    }

    public StandardUsernamePasswordCredentials lookupCredentials() {
        return ExecuteRequestEMConfig.lookupCredentials(this.url, this.credentials);
    }

    private static StandardUsernamePasswordCredentials lookupCredentials(String url, String credentialId) {
        return StringUtils.isBlank((String)credentialId) ? null : (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstanceOrNull(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withScope((CredentialsScope)CredentialsScope.GLOBAL), CredentialsMatchers.withId((String)credentialId)}));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecuteRequestEMConfig> {
        public String getDisplayName() {
            return "Execution Manager Config";
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            FormValidation ret = FormValidation.ok();
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                ret = FormValidation.error((String)("URL is invalid " + e.getMessage()));
            }
            return ret;
        }

        public FormValidation doCheckCredentials(@QueryParameter String credentials) {
            FormValidation ret = FormValidation.ok();
            return ret;
        }

        public ListBoxModel doFillCredentialsItems(@AncestorInPath ItemGroup context, @QueryParameter String url, @QueryParameter String credentialsId) {
            Jenkins _context;
            AbstractIdCredentialsListBoxModel data = null;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            data = _context == null || !_context.hasPermission(Jenkins.ADMINISTER) ? new StandardUsernameListBoxModel().includeCurrentValue(credentialsId) : new StandardUsernameListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), CredentialsMatchers.withScope((CredentialsScope)CredentialsScope.GLOBAL)).includeCurrentValue(credentialsId);
            return data;
        }

        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String credentials) {
            block9: {
                if (StringUtils.isBlank((String)credentials)) {
                    return FormValidation.error((String)"Credentials must be selected!");
                }
                try {
                    URL uRL = new URL(url);
                }
                catch (MalformedURLException e) {
                    return FormValidation.error((String)("URL is invalid " + e.getMessage()));
                }
                StandardUsernamePasswordCredentials creds = ExecuteRequestEMConfig.lookupCredentials(url, credentials);
                if (creds == null) {
                    return FormValidation.error((String)"Credentials lookup error!");
                }
                try {
                    ExecutionManagerServer ems = new ExecutionManagerServer(url, (UsernamePasswordCredentials)creds);
                    if (ems.login()) break block9;
                    EmResult result = ems.getLastEMResult();
                    String err = result.getResponse().statusPhrase();
                    if (result.getJsonData() == null) {
                        return FormValidation.error((String)err);
                    }
                    try {
                        err = result.getJsonData().getString("error_description");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FormValidation.error((String)err);
                }
                catch (Exception e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok((String)"Success");
        }
    }
}

