/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.worksoft.jenkinsci.plugins.em.ExecuteRequestCertifyProcess;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class ExecuteRequestCertifyProcessList
extends AbstractDescribableImpl<ExecuteRequestCertifyProcessList> {
    @Exported
    String database;
    @Exported
    String project;
    @Exported
    String folder;
    @Exported
    String requestName;
    @Exported
    List<ExecuteRequestCertifyProcess> processes;

    @DataBoundConstructor
    public ExecuteRequestCertifyProcessList(String database, String project, List<ExecuteRequestCertifyProcess> processes, String folder, String requestName) {
        this.database = database;
        this.project = project;
        this.processes = processes;
        this.folder = folder;
        this.requestName = requestName;
    }

    public List<ExecuteRequestCertifyProcess> getProcesses() {
        return this.processes;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getRequestName() {
        return this.requestName;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecuteRequestCertifyProcessList> {
        public String getDisplayName() {
            return "Certify Process Config";
        }

        public FormValidation doFolder(@QueryParameter String folder) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)folder)) {
                ret = FormValidation.error((String)"A folder must be specified!");
            }
            return ret;
        }

        public FormValidation doCheckDatabase(@QueryParameter String database) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)database)) {
                ret = FormValidation.error((String)"A database alias must be specified!");
            }
            return ret;
        }

        public FormValidation doCheckProject(@QueryParameter String project) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)project)) {
                ret = FormValidation.error((String)"A project must be specified!");
            }
            return ret;
        }

        public FormValidation doCheckRequestName(@QueryParameter String requestName) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)requestName)) {
                ret = FormValidation.error((String)"A request name must be specified!");
            }
            return ret;
        }
    }
}

