/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.worksoft.jenkinsci.plugins.em.EMItemCache;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequest;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public final class ExecuteRequestBookmark
extends AbstractDescribableImpl<ExecuteRequestBookmark> {
    @Exported
    private String name;
    @Exported
    private String folder;

    @DataBoundConstructor
    public ExecuteRequestBookmark(String name) {
        this.name = name;
        this.folder = "";
    }

    public String getName() {
        return this.name;
    }

    public String getFolder() {
        return this.folder;
    }

    @DataBoundSetter
    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecuteRequestBookmark> {
        @Nonnull
        public String getDisplayName() {
            return "Execute Bookmark";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            ListBoxModel listBox = EMItemCache.getCachedItems("bookmark");
            FormValidation ret = FormValidation.ok();
            String msg = name;
            if (msg.startsWith("ERROR") || listBox != null && (msg = ((ListBoxModel.Option)listBox.get((int)0)).value).startsWith("ERROR")) {
                ret = FormValidation.error((String)("Execution Manager error retrieving bookmarks - " + msg.replace("ERROR: ", "") + "!"));
            } else if (StringUtils.isEmpty((String)name)) {
                ret = FormValidation.error((String)"A bookmark must be specified!");
            }
            return ret;
        }

        public FormValidation doCheckFolder(@QueryParameter String folder) {
            FormValidation ret = FormValidation.ok();
            return ret;
        }

        public ListBoxModel doFillNameItems(@RelativePath(value="..") @QueryParameter String requestType, @RelativePath(value="../altEMConfig") @QueryParameter String url, @RelativePath(value="../altEMConfig") @QueryParameter String credentials) {
            return ExecuteRequest.fillItems("bookmark", url, credentials);
        }
    }
}

