/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.worksoft.jenkinsci.plugins.em.EMItemCache;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestBookmark;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestCertifyProcessList;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestEMConfig;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestParameter;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestParameters;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestPostExecute;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestRequest;
import com.worksoft.jenkinsci.plugins.em.ExecuteRequestWaitConfig;
import com.worksoft.jenkinsci.plugins.em.config.ExecutionManagerConfig;
import com.worksoft.jenkinsci.plugins.em.model.EmResult;
import com.worksoft.jenkinsci.plugins.em.model.ExecutionManagerServer;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ExecuteRequest
extends Builder
implements SimpleBuildStep {
    private static final Logger log = Logger.getLogger("jenkins.ExecuteRequest");
    private String requestType;
    private ExecuteRequestBookmark bookmark;
    private ExecuteRequestRequest request;
    private ExecuteRequestCertifyProcessList processList;
    private ExecuteRequestPostExecute postExecute;
    private ExecuteRequestEMConfig altEMConfig;
    private ExecuteRequestWaitConfig waitConfig;
    private ExecuteRequestParameters execParams;
    private ExecuteRequestEMConfig emConfig;
    private ExecutionManagerServer server;
    private Run<?, ?> run;
    private FilePath workspace;
    private Launcher launcher;
    private TaskListener listener;
    private ConsoleStream consoleOut;

    @DataBoundConstructor
    public ExecuteRequest(String requestType) {
        this.requestType = requestType;
        EMItemCache.invalidateItemsCache();
    }

    public boolean getExecParamsEnabled() {
        return this.getExecParams() != null;
    }

    public ExecuteRequestParameters getExecParams() {
        return this.execParams;
    }

    public boolean getPostExecuteEnabled() {
        return this.getPostExecute() != null;
    }

    public ExecuteRequestPostExecute getPostExecute() {
        return this.postExecute;
    }

    public boolean getWaitConfigEnabled() {
        return this.getWaitConfig() != null;
    }

    public ExecuteRequestWaitConfig getWaitConfig() {
        return this.waitConfig;
    }

    public boolean getAltEMConfigEnabled() {
        return this.getAltEMConfig() != null;
    }

    public ExecuteRequestEMConfig getAltEMConfig() {
        return this.altEMConfig;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public ExecuteRequestBookmark getBookmark() {
        EMItemCache.invalidateItemsCache();
        return this.bookmark;
    }

    public ExecuteRequestRequest getRequest() {
        EMItemCache.invalidateItemsCache();
        return this.request;
    }

    public ExecuteRequestCertifyProcessList getProcessList() {
        return this.processList;
    }

    @DataBoundSetter
    public void setRequestType(@Nonnull String requestType) {
        this.requestType = requestType;
    }

    @DataBoundSetter
    public void setBookmark(ExecuteRequestBookmark bookmark) {
        this.bookmark = bookmark;
    }

    @DataBoundSetter
    public void setRequest(ExecuteRequestRequest request) {
        this.request = request;
    }

    @DataBoundSetter
    public void setProcessList(ExecuteRequestCertifyProcessList processList) {
        this.processList = processList;
    }

    @DataBoundSetter
    public void setPostExecute(ExecuteRequestPostExecute postExecute) {
        this.postExecute = postExecute;
    }

    @DataBoundSetter
    public void setAltEMConfig(ExecuteRequestEMConfig altEMConfig) {
        this.altEMConfig = altEMConfig;
    }

    @DataBoundSetter
    public void setWaitConfig(ExecuteRequestWaitConfig waitConfig) {
        this.waitConfig = waitConfig;
    }

    @DataBoundSetter
    public void setExecParams(ExecuteRequestParameters execParams) {
        try {
            this.execParams = execParams;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Unable to set exec parameters " + e);
        }
    }

    public String emRequestTypeEquals(String given) {
        return String.valueOf(this.requestType != null && this.requestType.equals(given));
    }

    public static ListBoxModel fillItems(String emRequestType, String url, String credentials) {
        ListBoxModel items;
        block10: {
            items = new ListBoxModel();
            ExecutionManagerConfig globalConfig = (ExecutionManagerConfig)((Object)GlobalConfiguration.all().get(ExecutionManagerConfig.class));
            ExecuteRequestEMConfig emConfig = globalConfig != null ? globalConfig.getEmConfig() : null;
            ExecuteRequestEMConfig altEMConfig = new ExecuteRequestEMConfig(url, credentials);
            if (altEMConfig != null && altEMConfig.isValid()) {
                emConfig = altEMConfig;
            }
            if (emConfig != null) {
                ExecutionManagerServer server = new ExecutionManagerServer(emConfig.getUrl(), (UsernamePasswordCredentials)emConfig.lookupCredentials());
                try {
                    if (server.login()) {
                        JSONObject retrievedObjs = emRequestType.equals("request") ? server.requests() : server.bookmarks();
                        if (retrievedObjs != null) {
                            try {
                                items.add("-- Select a " + emRequestType + " --");
                                JSONArray objs = retrievedObjs.getJSONArray("objects");
                                for (int i = 0; i < objs.size(); ++i) {
                                    JSONObject req = objs.getJSONObject(i);
                                    String name = req.getString("Name");
                                    items.add(name);
                                }
                                break block10;
                            }
                            catch (Exception ignored) {
                                items.add("*** ERROR ***", "ERROR: Bad JSON");
                                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
                                break block10;
                            }
                        }
                        items.add("*** ERROR ***", "ERROR: Couldn't retrieve " + emRequestType + "s");
                        ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
                        break block10;
                    }
                    items.add("*** ERROR ***", "ERROR: Couldn't log in");
                    ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
                }
                catch (Exception ex) {
                    items.add("*** ERROR ***", "ERROR: Exception while logging in");
                    ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
                }
            } else {
                items.add("*** ERROR ***", "ERROR: No EM configuration");
                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
            }
        }
        EMItemCache.updateItemsCache(emRequestType, items);
        return items;
    }

    private HashMap<String, String> processParameters() throws InterruptedException, IOException {
        HashMap<String, String> ret = new HashMap<String, String>();
        EnvVars envVars = this.run.getEnvironment(this.listener);
        if (this.execParams != null && this.execParams.getList() != null) {
            for (ExecuteRequestParameter param : this.execParams.getList()) {
                String value = param.getValue();
                if (!StringUtils.isNotEmpty((String)param.getKey()) || !StringUtils.isNotEmpty((String)value)) continue;
                Matcher m = Pattern.compile("([^$]*)[$][{]([^}]*)[}]([^$]*)").matcher(value);
                StringBuilder expandedValue = new StringBuilder();
                boolean found = false;
                while (m.find()) {
                    found = true;
                    for (int i = 1; i <= m.groupCount(); ++i) {
                        if (i == 2) {
                            String envVar = (String)envVars.get((Object)m.group(i));
                            if (envVar == null) continue;
                            expandedValue.append(envVar);
                            continue;
                        }
                        expandedValue.append(m.group(i));
                    }
                }
                if (!found) {
                    expandedValue = new StringBuilder(value);
                }
                ret.put(param.getKey(), expandedValue.toString());
            }
        }
        return ret;
    }

    private void waitForCompletion(String guid) {
        long startTime;
        Long pollInterval;
        Long maxRunTime;
        boolean aborted = false;
        String abortReason = "";
        Long l = maxRunTime = this.waitConfig == null ? null : this.waitConfig.maxRunTimeInMillis();
        if (maxRunTime == null) {
            maxRunTime = TimeUnit.MILLISECONDS.convert(365L, TimeUnit.DAYS);
        }
        Long l2 = pollInterval = this.waitConfig == null ? null : this.waitConfig.pollIntervalInMillis();
        if (pollInterval == null) {
            pollInterval = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.SECONDS);
        }
        long currentTime = startTime = System.currentTimeMillis();
        long endTime = startTime + maxRunTime;
        SimpleDateFormat elapsedFmt = new SimpleDateFormat("HH:mm:ss.SSS");
        elapsedFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        String elapsedTime = elapsedFmt.format(new Date(currentTime - startTime));
        JSONArray prevTasks = null;
        JSONObject response = null;
        this.consoleOut.println("Waiting for execution to complete...");
        while (true) {
            EmResult result;
            EmResult statusResult;
            if (!(statusResult = this.server.executionStatus(guid)).is200()) {
                this.consoleOut.println("\n*** ERROR: EM error while checking execution status:");
                this.consoleOut.printlnIndented("*** ERROR:   ", statusResult.dumpDebug());
                break;
            }
            response = statusResult.getJsonData();
            try {
                String jobStatus = response.getString("Status");
                String jobExecutionStatus = response.getString("ExecutionStatus");
                this.consoleOut.println("\nElapsed time=" + elapsedTime + " - " + jobStatus + "," + jobExecutionStatus + (aborted ? " *** ABORTING ***" : ""));
                if (response.containsKey((Object)"Tasks")) {
                    JSONArray tasks = response.getJSONArray("Tasks");
                    if (prevTasks == null || !prevTasks.equals((Object)tasks)) {
                        this.consoleOut.println("Name  Status                     Resource        Last Error");
                        this.consoleOut.println("----- -------------------------- --------------- -----------------------------------");
                        for (int i = 0; i < tasks.size(); ++i) {
                            JSONObject task = tasks.getJSONObject(i);
                            String name = task.getString("Name");
                            String executionStatus = task.getString("ExecutionStatus");
                            String resourceName = task.getString("ResourceName");
                            String lastReportedError = task.getString("LastReportedError");
                            String status = task.getString("Status");
                            if (StringUtils.isNotEmpty((String)status) && StringUtils.isNotEmpty((String)executionStatus)) {
                                status = status + ",";
                            }
                            status = status + executionStatus;
                            this.consoleOut.println(name + ":");
                            this.consoleOut.println(String.format("      %-26.26s %-15.15s %s", StringUtils.abbreviate((String)status, (int)26), StringUtils.abbreviate((String)resourceName, (int)15), lastReportedError));
                            prevTasks = tasks;
                        }
                    }
                }
                if (jobStatus.toUpperCase().equals("COMPLETED")) {
                    if (!aborted && jobExecutionStatus.toUpperCase().equals("FAILED")) {
                        this.run.setResult(Result.FAILURE);
                        break;
                    }
                    if (!jobExecutionStatus.toUpperCase().equals("PASSED")) break;
                    this.run.setResult(Result.SUCCESS);
                    break;
                }
            }
            catch (JSONException e) {
                this.consoleOut.println("\n*** ERROR: unexpected error while processing status");
                this.consoleOut.println("*** ERROR: exception: " + (Object)((Object)e));
                this.consoleOut.println("*** ERROR: exception: " + e.getMessage());
                this.consoleOut.println("*** ERROR: stack trace:  ");
                this.consoleOut.printlnIndented("*** ERROR:    ", e.getStackTrace());
            }
            try {
                Thread.sleep(pollInterval);
                currentTime = System.currentTimeMillis();
                elapsedTime = elapsedFmt.format(new Date(currentTime - startTime));
                if (maxRunTime != null && currentTime >= endTime) {
                    if (aborted) {
                        this.consoleOut.println("\n*** ERROR: Abort timed out!!! - abandoning...");
                        abortReason = abortReason + " (abandoned!)";
                        break;
                    }
                    this.consoleOut.println("\n*** ERROR: Execution timed out after " + elapsedTime + " - aborting...");
                    abortReason = " due to max wait time exceeded";
                    result = this.server.executionAbort(guid);
                    if (!result.is200()) {
                        this.consoleOut.println("\n*** ERROR: EM error aborting execution:");
                        this.consoleOut.printlnIndented("*** ERROR:   ", result.dumpDebug());
                    }
                    this.run.setResult(Result.ABORTED);
                }
            }
            catch (InterruptedException e) {
                if (aborted) {
                    this.consoleOut.println("\n*** ERROR: User requested abort of execution (again) after " + elapsedTime);
                    abortReason = abortReason + " (forced!)";
                    break;
                }
                this.consoleOut.println("\n*** ERROR: User requested abort of execution after " + elapsedTime);
                abortReason = " due to user request";
                this.run.setResult(Result.ABORTED);
            }
            if (this.run.getResult() != Result.ABORTED) continue;
            result = this.server.executionAbort(guid);
            if (!result.is200() && !aborted) {
                this.consoleOut.println("\n*** ERROR: Error aborting execution:");
                this.consoleOut.printlnIndented("*** ERROR:   ", result.dumpDebug());
            }
            if (aborted) continue;
            pollInterval = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
            aborted = true;
            maxRunTime = TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS);
            endTime = currentTime + maxRunTime;
        }
        try {
            FilePath resFile = new FilePath(this.workspace.getChannel(), this.workspace + "/execMan-result.json");
            if (response != null) {
                resFile.write(response.toString(), null);
                this.consoleOut.println("\nResults written to " + resFile);
            }
        }
        catch (Exception e) {
            this.consoleOut.println("\n*** ERROR: unexpected error while writing results");
            this.consoleOut.println("*** ERROR: exception: " + e);
            this.consoleOut.println("*** ERROR: exception: " + e.getMessage());
            this.consoleOut.println("*** ERROR: stack trace:  ");
            this.consoleOut.printlnIndented("*** ERROR:    ", e.getStackTrace());
        }
        this.consoleOut.println("\n\nExecution " + this.run.getResult().toString() + " after - " + elapsedTime + abortReason);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.run = run;
        this.workspace = workspace;
        this.launcher = launcher;
        this.listener = listener;
        this.consoleOut = new ConsoleStream(listener.getLogger());
        FileUtils.deleteQuietly((File)new File(workspace + "/execMan-result.json"));
        ExecutionManagerConfig globalConfig = (ExecutionManagerConfig)((Object)GlobalConfiguration.all().get(ExecutionManagerConfig.class));
        ExecuteRequestEMConfig executeRequestEMConfig = this.emConfig = globalConfig != null ? globalConfig.getEmConfig() : null;
        if (this.altEMConfig != null && this.altEMConfig.isValid()) {
            this.emConfig = this.getAltEMConfig();
        }
        String guid = null;
        try {
            if (this.emConfig != null && this.emConfig.isValid()) {
                this.server = new ExecutionManagerServer(this.emConfig.getUrl(), (UsernamePasswordCredentials)this.emConfig.lookupCredentials());
                if (this.server.login()) {
                    try {
                        String methName = "execute_" + this.requestType.toUpperCase().trim();
                        Method meth = ((Object)((Object)this)).getClass().getDeclaredMethod(methName, new Class[0]);
                        guid = (String)meth.invoke((Object)this, new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        this.consoleOut.println("\n*** ERROR: Don't know how to execute '" + this.requestType + "'");
                        run.setResult(Result.FAILURE);
                    }
                    catch (IllegalAccessException ex) {
                        this.consoleOut.println("\n*** ERROR: Couldn't execute '" + this.requestType + "'");
                        this.consoleOut.println("*** ERROR: unexpected error while processing request: " + this.requestType);
                        this.consoleOut.println("*** ERROR: exception: " + ex);
                        this.consoleOut.println("*** ERROR: exception: " + ex.getMessage());
                        this.consoleOut.println("*** ERROR: stack trace:  ");
                        this.consoleOut.printlnIndented("*** ERROR:   ", ex.getStackTrace());
                        run.setResult(Result.FAILURE);
                    }
                    catch (InvocationTargetException ex) {
                        this.consoleOut.println("*** ERROR: Exception thrown while executing '" + this.requestType + "'");
                        run.setResult(Result.FAILURE);
                    }
                } else {
                    EmResult result = this.server.getLastEMResult();
                    this.consoleOut.println("\n*** ERROR: Can't log in to '" + this.emConfig.getUrl() + "':");
                    this.consoleOut.printlnIndented("*** ERROR:   ", result.getResponseData());
                    run.setResult(Result.FAILURE);
                }
            } else {
                this.consoleOut.println("\n*** ERROR: A valid Execution Manager configuration must be specified!");
                run.setResult(Result.FAILURE);
            }
        }
        catch (Exception ex) {
            this.consoleOut.println("\n*** ERROR: Unexpected error while processing request type: " + this.requestType);
            this.consoleOut.println("*** ERROR: exception: " + ex);
            this.consoleOut.println("*** ERROR: exception: " + ex.getMessage());
            this.consoleOut.println("*** ERROR: stack trace:  ");
            this.consoleOut.printlnIndented("*** ERROR:   ", ex.getStackTrace());
            run.setResult(Result.FAILURE);
        }
        if (run.getResult() != Result.FAILURE) {
            if (guid == null) {
                this.consoleOut.println("\n*** ERROR: An unexpected error occurred while requesting execution!");
                run.setResult(Result.FAILURE);
            } else {
                this.waitForCompletion(guid);
            }
        }
    }

    public String execute_REQUEST() throws InterruptedException, IOException {
        String guid = null;
        if (StringUtils.isEmpty((String)this.request.getName())) {
            this.consoleOut.println("\n*** ERROR: A request name or ID must be specified!");
            this.run.setResult(Result.FAILURE);
        } else {
            String reqID = null;
            String theReq = this.request.getName().trim();
            JSONObject reqs = this.server.requests();
            if (reqs != null) {
                try {
                    JSONArray objs = reqs.getJSONArray("objects");
                    for (int i = 0; i < objs.size(); ++i) {
                        JSONObject req = objs.getJSONObject(i);
                        if (!req.getString("Name").equals(theReq) && !req.getString("RequestID").equals(theReq)) continue;
                        reqID = req.getString("RequestID");
                        break;
                    }
                }
                catch (Exception ex) {
                    this.consoleOut.println("\n*** ERROR: unexpected error during execute_REQUEST:");
                    this.consoleOut.println("*** ERROR: unexpected error while processing request: " + this.requestType);
                    this.consoleOut.println("*** ERROR: exception: " + ex);
                    this.consoleOut.println("*** ERROR: exception: " + ex.getMessage());
                    this.consoleOut.println("*** ERROR: stack trace:  ");
                    this.consoleOut.printlnIndented("*** ERROR:   ", ex.getStackTrace());
                    this.run.setResult(Result.FAILURE);
                }
            }
            if (reqID == null) {
                this.consoleOut.println("\n*** ERROR: No such request '" + theReq + "'!");
                this.run.setResult(Result.FAILURE);
            } else {
                this.consoleOut.println("Requesting execution of request '" + theReq + "'(id=" + reqID + ")");
                this.consoleOut.println("   on Execution Manager @ " + this.emConfig.getUrl());
                TreeMap<String, String> params = new TreeMap<String, String>(this.processParameters());
                if (params.keySet().size() > 0) {
                    this.consoleOut.println("   with parameters (key=value):");
                    for (String key : params.keySet()) {
                        String sanitizedValue;
                        String value = (String)params.get(key);
                        if (!value.equals(sanitizedValue = this.server.sanitizeParameter(value))) {
                            value = sanitizedValue + " (sanitized from '" + value + "')";
                        }
                        this.consoleOut.println("      " + key + "=" + value);
                    }
                }
                this.consoleOut.println("\n");
                guid = this.server.executeRequest(reqID, params);
                if (guid == null) {
                    EmResult result = this.server.getLastEMResult();
                    String err = result.dumpDebug();
                    if (result.getJsonData() != null) {
                        try {
                            err = result.getJsonData().getString("Message");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.consoleOut.println("\n*** ERROR: Request to execute '" + theReq + "' failed:");
                    this.consoleOut.printlnIndented("   ", err);
                }
            }
        }
        return guid;
    }

    public String execute_BOOKMARK() throws InterruptedException, IOException {
        String guid = null;
        if (this.bookmark == null || StringUtils.isEmpty((String)this.bookmark.getName())) {
            this.consoleOut.println("\n*** ERROR: A bookmark name or ID must be specified!");
            this.run.setResult(Result.FAILURE);
        } else {
            String bmarkID = null;
            String theBmark = this.bookmark.getName().trim();
            JSONObject bmarks = this.server.bookmarks();
            if (bmarks != null) {
                try {
                    JSONArray objs = bmarks.getJSONArray("objects");
                    for (int i = 0; i < objs.size(); ++i) {
                        JSONObject bmark = objs.getJSONObject(i);
                        if (!bmark.getString("Name").equals(theBmark) && !bmark.getString("Id").equals(theBmark)) continue;
                        bmarkID = bmark.getString("Id");
                        break;
                    }
                }
                catch (Exception ex) {
                    this.consoleOut.println("\n*** ERROR: unexpected error during execute_REQUEST:");
                    this.consoleOut.println("*** ERROR: unexpected error while processing request: " + this.requestType);
                    this.consoleOut.println("*** ERROR: exception: " + ex);
                    this.consoleOut.println("*** ERROR: exception: " + ex.getMessage());
                    this.consoleOut.println("*** ERROR: stack trace:  ");
                    this.consoleOut.printlnIndented("*** ERROR:   ", ex.getStackTrace());
                    this.run.setResult(Result.FAILURE);
                }
            }
            if (bmarkID == null) {
                this.consoleOut.println("\n*** ERROR: No such bookmark '" + theBmark + "'!");
                this.run.setResult(Result.FAILURE);
            } else {
                TreeMap<String, String> params;
                this.consoleOut.println("Requesting execution of bookmark '" + theBmark + "'(id=" + bmarkID + ")");
                this.consoleOut.println("   on Execution Manager @ " + this.emConfig.getUrl());
                if (StringUtils.isNotEmpty((String)this.bookmark.getFolder())) {
                    this.consoleOut.println("   with results folder='" + this.bookmark.getFolder() + "'");
                }
                if ((params = new TreeMap<String, String>(this.processParameters())).keySet().size() > 0) {
                    this.consoleOut.println("   with parameters (key=value):");
                    for (String key : params.keySet()) {
                        String sanitizedValue;
                        String value = (String)params.get(key);
                        if (!value.equals(sanitizedValue = this.server.sanitizeParameter(value))) {
                            value = sanitizedValue + " (sanitized from '" + value + "')";
                        }
                        this.consoleOut.println("      " + key + "=" + value);
                    }
                }
                this.consoleOut.println("\n");
                guid = this.server.executeBookmark(bmarkID, this.bookmark.getFolder(), params);
                if (guid == null) {
                    EmResult result = this.server.getLastEMResult();
                    String err = result.dumpDebug();
                    if (result.getJsonData() != null) {
                        try {
                            err = result.getJsonData().getString("Message");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.consoleOut.println("\n*** ERROR: Request to execute bookmark failed:");
                    this.consoleOut.printlnIndented("   ", err);
                }
            }
        }
        return guid;
    }

    private String execute_PROCESSLIST() throws InterruptedException, IOException {
        JSONObject processes = new JSONObject();
        JSONArray processList = new JSONArray();
        String guid = null;
        this.consoleOut.println("Requesting execution of Certify processes");
        this.consoleOut.println("   on Execution Manager @ " + this.emConfig.getUrl());
        this.consoleOut.println("   with database alias='" + this.getProcessList().getDatabase() + "'");
        processes.put("CertifyDatabaseAlias", (Object)this.getProcessList().getDatabase());
        this.consoleOut.println("   with project name='" + this.getProcessList().getProject() + "'");
        processes.put("ProjectName", (Object)this.getProcessList().getProject());
        this.consoleOut.println("   with request name='" + this.getProcessList().getRequestName() + "'");
        processes.put("RequestName", (Object)this.getProcessList().getRequestName());
        if (StringUtils.isNotEmpty((String)this.getProcessList().getFolder())) {
            this.consoleOut.println("   with results folder='" + this.getProcessList().getFolder() + "'");
            processes.put("ResultsFolder", (Object)this.getProcessList().getFolder());
        }
        this.consoleOut.println("   with process path(s):");
        for (Object proc : this.getProcessList().getProcesses()) {
            if (!StringUtils.isNotEmpty((String)proc.getProcessPath())) continue;
            this.consoleOut.println("      " + proc.getProcessPath());
            processList.add((Object)proc.getProcessPath());
        }
        processes.put("Processes", (Object)processList);
        TreeMap<String, String> params = new TreeMap<String, String>(this.processParameters());
        if (params.keySet().size() > 0) {
            this.consoleOut.println("   with parameters (key=value):");
            for (String key : params.keySet()) {
                String sanitizedValue;
                String value = (String)params.get(key);
                if (!value.equals(sanitizedValue = this.server.sanitizeParameter(value))) {
                    value = sanitizedValue + " (sanitized from '" + value + "')";
                }
                this.consoleOut.println("      " + key + "=" + value);
            }
        }
        this.consoleOut.println("\n");
        guid = this.server.executeProcesses(processes, params);
        if (guid == null) {
            EmResult result = this.server.getLastEMResult();
            String err = result.dumpDebug();
            if (result.getJsonData() != null) {
                try {
                    err = result.getJsonData().getString("Message");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.consoleOut.println("\n*** ERROR: Request to execute Certify process(es) failed:");
            this.consoleOut.printlnIndented("   ", err);
        }
        return guid;
    }

    @Symbol(value={"execMan"})
    @Extension
    public static final class ExecutionManagerBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return "Run Execution Manager Request";
        }
    }

    public class ConsoleStream
    extends PrintStream {
        public ConsoleStream(OutputStream out) {
            super(out);
        }

        @Override
        public void println(String string) {
            Date now = new Date();
            DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
            Scanner scanner = new Scanner(string);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                super.println("[" + dateFormatter.format(now) + "] " + line);
            }
            scanner.close();
        }

        public void printlnIndented(String indent, String string) {
            Scanner scanner = new Scanner(string);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                this.println(indent + line);
            }
            scanner.close();
        }

        public void printlnIndented(String indent, Object[] objects) {
            for (Object obj : objects) {
                this.printlnIndented(indent, obj.toString());
            }
        }
    }
}

