/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.ws_cleanup.Messages;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import hudson.plugins.ws_cleanup.WsCleanupMatrixAggregator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class WsCleanup
extends Notifier
implements MatrixAggregatable,
SimpleBuildStep {
    public static final String LOG_PREFIX = "[WS-CLEANUP] ";
    private List<Pattern> patterns = Collections.emptyList();
    private boolean deleteDirs = false;
    @Deprecated
    private boolean skipWhenFailed = false;
    private boolean cleanWhenSuccess = true;
    private boolean cleanWhenUnstable = true;
    private boolean cleanWhenFailure = true;
    private boolean cleanWhenNotBuilt = true;
    private boolean cleanWhenAborted = true;
    private boolean notFailBuild = false;
    private boolean cleanupMatrixParent = false;
    private String externalDelete = "";

    @DataBoundConstructor
    public WsCleanup() {
    }

    @DataBoundSetter
    public void setPatterns(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @DataBoundSetter
    public void setDeleteDirs(boolean deleteDirs) {
        this.deleteDirs = deleteDirs;
    }

    @Deprecated
    @DataBoundSetter
    public void setSkipWhenFailed(boolean skipWhenFailed) {
        this.skipWhenFailed = skipWhenFailed;
    }

    @DataBoundSetter
    public void setCleanWhenSuccess(boolean cleanWhenSuccess) {
        this.cleanWhenSuccess = cleanWhenSuccess;
    }

    @DataBoundSetter
    public void setCleanWhenUnstable(boolean cleanWhenUnstable) {
        this.cleanWhenUnstable = cleanWhenUnstable;
    }

    @DataBoundSetter
    public void setCleanWhenFailure(boolean cleanWhenFailure) {
        this.cleanWhenFailure = cleanWhenFailure;
    }

    @DataBoundSetter
    public void setCleanWhenNotBuilt(boolean cleanWhenNotBuilt) {
        this.cleanWhenNotBuilt = cleanWhenNotBuilt;
    }

    @DataBoundSetter
    public void setCleanWhenAborted(boolean cleanWhenAborted) {
        this.cleanWhenAborted = cleanWhenAborted;
    }

    @DataBoundSetter
    public void setNotFailBuild(boolean notFailBuild) {
        this.notFailBuild = notFailBuild;
    }

    @DataBoundSetter
    public void setCleanupMatrixParent(boolean cleanupMatrixParent) {
        this.cleanupMatrixParent = cleanupMatrixParent;
    }

    @DataBoundSetter
    public void setExternalDelete(String externalDelete) {
        this.externalDelete = externalDelete;
    }

    public Object readResolve() {
        if (!(this.cleanWhenSuccess || this.cleanWhenUnstable || this.cleanWhenFailure || this.cleanWhenNotBuilt || this.cleanWhenAborted)) {
            this.cleanWhenSuccess = true;
            this.cleanWhenUnstable = true;
            this.cleanWhenFailure = true;
            this.cleanWhenNotBuilt = true;
            this.cleanWhenAborted = true;
        }
        if (this.skipWhenFailed) {
            this.skipWhenFailed = false;
            this.cleanWhenSuccess = true;
            this.cleanWhenUnstable = true;
            this.cleanWhenFailure = false;
            this.cleanWhenNotBuilt = false;
            this.cleanWhenAborted = false;
        }
        return this;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public boolean getNotFailBuild() {
        return this.notFailBuild;
    }

    @Deprecated
    public boolean isSkipWhenFailed() {
        return this.skipWhenFailed;
    }

    public boolean isCleanWhenSuccess() {
        return this.cleanWhenSuccess;
    }

    public boolean isCleanWhenUnstable() {
        return this.cleanWhenUnstable;
    }

    public boolean isCleanWhenFailure() {
        return this.cleanWhenFailure;
    }

    public boolean isCleanWhenNotBuilt() {
        return this.cleanWhenNotBuilt;
    }

    public boolean isCleanWhenAborted() {
        return this.cleanWhenAborted;
    }

    public boolean getCleanupMatrixParent() {
        return this.cleanupMatrixParent;
    }

    public String getExternalDelete() {
        return this.externalDelete;
    }

    private boolean shouldCleanBuildBasedOnState(@CheckForNull Result result) {
        if (result == null) {
            return true;
        }
        if (result.equals(Result.SUCCESS)) {
            return this.cleanWhenSuccess;
        }
        if (result.equals(Result.UNSTABLE)) {
            return this.cleanWhenUnstable;
        }
        if (result.equals(Result.FAILURE)) {
            return this.cleanWhenFailure;
        }
        if (result.equals(Result.NOT_BUILT)) {
            return this.cleanWhenNotBuilt;
        }
        if (result.equals(Result.ABORTED)) {
            return this.cleanWhenAborted;
        }
        return true;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            if (workspace == null || !workspace.exists()) {
                return;
            }
            listener.getLogger().append("[WS-CLEANUP] Deleting project workspace...");
            if (!this.shouldCleanBuildBasedOnState(build.getResult())) {
                listener.getLogger().println("[WS-CLEANUP] Skipped based on build state " + build.getResult());
                return;
            }
            RemoteCleaner cleaner = RemoteCleaner.get(this.patterns, this.deleteDirs, this.externalDelete, listener, build);
            cleaner.perform(workspace);
            listener.getLogger().println("[WS-CLEANUP] done");
        }
        catch (Exception ex) {
            Logger.getLogger(WsCleanup.class.getName()).log(Level.SEVERE, null, ex);
            if (this.notFailBuild) {
                listener.getLogger().append("Cannot delete workspace: " + ex.getCause() + "\n");
                listener.getLogger().append("Option not to fail the build is turned on, so let's continue\n");
                return;
            }
            listener.getLogger().append("Cannot delete workspace :" + ex.getMessage() + "\n");
            throw new AbortException("Cannot delete workspace: " + ex.getMessage());
        }
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (this.cleanupMatrixParent) {
            return new WsCleanupMatrixAggregator(build, launcher, listener, this.patterns, this.deleteDirs, this.cleanWhenSuccess, this.cleanWhenUnstable, this.cleanWhenFailure, this.cleanWhenNotBuilt, this.cleanWhenAborted, this.notFailBuild, this.externalDelete);
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean isMatrixProject(Object o) {
        return o instanceof MatrixProject;
    }

    @Symbol(value={"cleanWs"})
    @Extension(ordinal=-9999.0)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(WsCleanup.class);
        }

        public String getDisplayName() {
            return Messages.WsCleanup_Delete_workspace();
        }

        public boolean isApplicable(Class clazz) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

