/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;

class Wipeout
extends RemoteCleaner {
    static Wipeout INSTANCE = new Wipeout();
    private static final Logger LOGGER = Logger.getLogger(Wipeout.class.getName());

    Wipeout() {
    }

    static Wipeout getInstance() {
        return INSTANCE;
    }

    @Override
    protected void perform(FilePath workspace) throws IOException, InterruptedException {
        FilePath deleteMe = workspace.withSuffix("_ws-cleanup_" + System.currentTimeMillis());
        Computer computer = workspace.toComputer();
        if (computer == null) {
            this.performDelete(workspace);
            return;
        }
        workspace.renameTo(deleteMe);
        if (!deleteMe.exists()) {
            LOGGER.log(Level.WARNING, "Cleaning workspace synchronously. Failed to rename {0} to {1}.", new Object[]{workspace.getRemote(), deleteMe.getName()});
            this.performDelete(workspace);
            return;
        }
        AsyncResourceDisposer.get().dispose(new Disposable[]{new DisposableImpl(deleteMe, computer.getName())});
    }

    void performDelete(FilePath workspace) throws IOException, InterruptedException {
        workspace.deleteRecursive();
    }

    private static final class DisposableImpl
    implements Disposable {
        private static final long serialVersionUID = 1L;
        private final String node;
        private final String path;

        private DisposableImpl(FilePath ws, String computer) {
            this.node = computer;
            this.path = ws.getRemote();
        }

        @Nonnull
        public Disposable.State dispose() throws Throwable {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return Disposable.State.TO_DISPOSE;
            }
            Computer computer = j.getComputer(this.node);
            if (computer == null) {
                return Disposable.State.PURGED;
            }
            FilePath ws = new FilePath(computer.getChannel(), this.path);
            try {
                INSTANCE.performDelete(ws);
            }
            catch (IOException ex) {
                Throwable cause = ex.getCause();
                if (cause != null && ex.getMessage().startsWith("remote file operation failed:")) {
                    throw cause;
                }
                throw ex;
            }
            return ws.exists() ? Disposable.State.TO_DISPOSE : Disposable.State.PURGED;
        }

        @Nonnull
        public String getDisplayName() {
            return "Workspace " + (this.node.isEmpty() ? "master" : this.node) + ':' + this.path;
        }
    }
}

