/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class Pattern
implements Serializable,
Describable<Pattern> {
    private final String pattern;
    private PatternType type;

    @DataBoundConstructor
    public Pattern(String pattern, PatternType type) {
        this.pattern = pattern;
        this.type = type;
    }

    public Object readResolve() {
        if (this.type == null) {
            this.type = PatternType.INCLUDE;
        }
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternType getType() {
        return this.type;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(this.getClass());
    }

    public static enum PatternType {
        INCLUDE,
        EXCLUDE;

    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Pattern> {
        public static final ListBoxModel TYPES = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Include", PatternType.INCLUDE.toString()), new ListBoxModel.Option("Exclude", PatternType.EXCLUDE.toString())});

        public String getDisplayName() {
            return "Directory scanner pattern";
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillTypeItems() {
            return TYPES;
        }
    }
}

