/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import hudson.remoting.VirtualChannel;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import jenkins.security.Roles;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

class Cleanup
extends RemoteCleaner
implements FilePath.FileCallable<Object> {
    private List<Pattern> patterns;
    private final boolean deleteDirs;
    private String deleteCommand = null;
    private TaskListener listener = null;

    public Cleanup(List<Pattern> patterns, boolean deleteDirs, EnvironmentVariablesNodeProperty environment, String command, TaskListener listener) {
        this.deleteDirs = deleteDirs;
        this.listener = listener;
        this.patterns = patterns == null ? Collections.emptyList() : patterns;
        String string = this.deleteCommand = command == null || command.isEmpty() ? null : command;
        if (environment != null && this.deleteCommand != null) {
            this.deleteCommand = (String)environment.getEnvVars().get((Object)command);
        }
        if (patterns == null) {
            patterns = new ArrayList<Pattern>();
            patterns.add(new Pattern("**/*", Pattern.PatternType.INCLUDE));
        }
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public Object invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        String[] nonFollowedSymlinks;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setFollowSymlinks(false);
        ds.setBasedir(f);
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (Pattern pattern : this.patterns) {
            if (pattern.getType() == Pattern.PatternType.INCLUDE) {
                includes.add(pattern.getPattern());
                continue;
            }
            excludes.add(pattern.getPattern());
        }
        if (includes.isEmpty()) {
            includes.add("**/*");
        }
        String[] includesArray = new String[includes.size()];
        String[] excludesArray = new String[excludes.size()];
        includes.toArray(includesArray);
        excludes.toArray(excludesArray);
        ds.setIncludes(includesArray);
        ds.setExcludes(excludesArray);
        ds.scan();
        int length = ds.getIncludedFilesCount();
        if (this.deleteDirs) {
            length += ds.getIncludedDirsCount();
        }
        String[] toDelete = new String[length];
        System.arraycopy(ds.getIncludedFiles(), 0, toDelete, 0, ds.getIncludedFilesCount());
        if (this.deleteDirs) {
            System.arraycopy(ds.getIncludedDirectories(), 0, toDelete, ds.getIncludedFilesCount(), ds.getIncludedDirsCount());
        }
        for (String path : toDelete) {
            if (this.deleteCommand != null) {
                List<String> cmdList = this.fixQuotesAndExpand(new File(f, path).getPath());
                this.doDelete(cmdList);
                continue;
            }
            Util.deleteRecursive((File)new File(f, path));
        }
        for (String link : nonFollowedSymlinks = ds.getNotFollowedSymlinks()) {
            if (this.deleteCommand != null) {
                List<String> cmdList = this.fixQuotesAndExpand(new File(link).getPath());
                this.doDelete(cmdList);
                continue;
            }
            Util.deleteRecursive((File)new File(link));
        }
        return null;
    }

    private List<String> fixQuotesAndExpand(String fullPath) {
        String tempCommand = this.deleteCommand.contains("%s") ? this.deleteCommand.replaceAll("%s", "\"" + Matcher.quoteReplacement(fullPath) + "\"") : this.deleteCommand + " " + fullPath;
        ArrayList<String> cmdList = new ArrayList<String>();
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\"([^\"]+)\"|(\\S+)");
        Matcher m = p.matcher(tempCommand);
        while (m.find()) {
            if (m.group(1) != null) {
                cmdList.add(m.group(1));
            }
            if (m.group(2) == null) continue;
            cmdList.add(m.group(2));
        }
        return cmdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(List<String> cmdList) throws IOException, InterruptedException {
        Process deletProc = new ProcessBuilder(cmdList).start();
        int exit = deletProc.waitFor();
        if (exit != 0) {
            this.listener.error("Cleanup command '%s' failed with code %d:", new Object[]{Util.join(cmdList, (String)" "), exit});
            InputStream err = deletProc.getErrorStream();
            try {
                Util.copyStream((InputStream)err, (OutputStream)this.listener.getLogger());
            }
            finally {
                IOUtils.closeQuietly((InputStream)err);
            }
        }
    }

    @Override
    protected void perform(FilePath workspace) throws IOException, InterruptedException {
        workspace.act((FilePath.FileCallable)this);
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

