/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.pipeline;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.jenkins.model.WhiteSourceDescriptor;
import org.whitesource.jenkins.model.WhiteSourceStep;

public class WhiteSourcePipelineStep
extends Step {
    private String product;
    private String productVersion;
    private String jobCheckPolicies;
    private String jobForceUpdate;
    private String jobApiToken;
    private String jobUserKey;
    private String projectToken;
    private String requesterEmail;
    private String libIncludes;
    private String libExcludes;

    @DataBoundConstructor
    public WhiteSourcePipelineStep(String jobCheckPolicies, String jobForceUpdate, String jobApiToken, String jobUserKey, String product, String productVersion, String projectToken, String libIncludes, String libExcludes, String requesterEmail) {
        this.jobCheckPolicies = jobCheckPolicies;
        this.jobForceUpdate = jobForceUpdate;
        this.jobApiToken = jobApiToken;
        this.jobUserKey = jobUserKey;
        this.product = product;
        this.productVersion = productVersion;
        this.projectToken = projectToken;
        this.libIncludes = libIncludes;
        this.libExcludes = libExcludes;
        this.requesterEmail = requesterEmail;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    public String getProduct() {
        return this.product;
    }

    @DataBoundSetter
    public void setProduct(String product) {
        this.product = product;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    @DataBoundSetter
    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getJobCheckPolicies() {
        return this.jobCheckPolicies;
    }

    @DataBoundSetter
    public void setJobCheckPolicies(String jobCheckPolicies) {
        this.jobCheckPolicies = jobCheckPolicies;
    }

    public String getJobForceUpdate() {
        return this.jobForceUpdate;
    }

    @DataBoundSetter
    public void setJobForceUpdate(String jobForceUpdate) {
        this.jobForceUpdate = jobForceUpdate;
    }

    public String getJobApiToken() {
        return this.jobApiToken;
    }

    @DataBoundSetter
    public void setJobApiToken(String jobApiToken) {
        this.jobApiToken = jobApiToken;
    }

    public String getJobUserKey() {
        return this.jobUserKey;
    }

    @DataBoundSetter
    public void setJobUserKey(String jobUserKey) {
        this.jobUserKey = jobUserKey;
    }

    public String getProjectToken() {
        return this.projectToken;
    }

    @DataBoundSetter
    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    @DataBoundSetter
    public void setRequesterEmail(String requesterEmail) {
        this.requesterEmail = requesterEmail;
    }

    public String getLibIncludes() {
        return this.libIncludes;
    }

    @DataBoundSetter
    public void setLibIncludes(String libIncludes) {
        this.libIncludes = libIncludes;
    }

    public String getLibExcludes() {
        return this.libExcludes;
    }

    @DataBoundSetter
    public void setLibExcludes(String libExcludes) {
        this.libExcludes = libExcludes;
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 8178356851772162243L;
        private final transient WhiteSourcePipelineStep step;

        protected Execution(@Nonnull StepContext context, WhiteSourcePipelineStep step) {
            super(context);
            this.step = step;
        }

        public Void run() throws Exception {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            assert (listener != null);
            PrintStream logger = listener.getLogger();
            logger.println("Updating White Source.");
            Run run = (Run)this.getContext().get(Run.class);
            WhiteSourceStep whiteSourceStep = new WhiteSourceStep(this.step, new WhiteSourceDescriptor((DescriptorImpl)this.step.getDescriptor()));
            if (StringUtils.isBlank((String)whiteSourceStep.getJobApiToken())) {
                logger.println("No API token configured. Skipping update.");
                return null;
            }
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            Collection<AgentProjectInfo> projectInfos = whiteSourceStep.getProjectInfos(run, listener, workspace, true);
            if (projectInfos.isEmpty()) {
                logger.println("No open source information found.");
            } else {
                whiteSourceStep.update(run, listener, projectInfos);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        private String serviceUrl;
        private String apiToken;
        private String userKey;
        private String pipelineCheckPolicies;
        private boolean globalForceUpdate;
        private boolean failOnError;
        private boolean overrideProxySettings;
        private String server;
        private String port;
        private String userName;
        private String password;
        private String connectionTimeout;
        private String connectionRetries;
        private String connectionRetriesInterval;

        public DescriptorImpl() {
            this.load();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(FilePath.class, Run.class, TaskListener.class));
        }

        public String getFunctionName() {
            return "whitesource";
        }

        public String getDisplayName() {
            return "Scan dependencies and update WhiteSource";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.serviceUrl = json.getString("serviceUrl");
            this.apiToken = json.getString("apiToken");
            this.userKey = json.getString("userKey");
            this.pipelineCheckPolicies = json.getString("pipelineCheckPolicies");
            this.failOnError = json.getBoolean("failOnError");
            this.globalForceUpdate = json.getBoolean("globalForceUpdate");
            JSONObject proxySettings = (JSONObject)json.get("proxySettings");
            if (proxySettings == null) {
                this.overrideProxySettings = false;
            } else {
                this.overrideProxySettings = true;
                this.userName = proxySettings.getString("userName");
                this.password = proxySettings.getString("password");
                this.server = proxySettings.getString("server");
                this.port = proxySettings.getString("port");
            }
            this.connectionTimeout = json.getString("connectionTimeout");
            this.connectionRetries = json.getString("connectionRetries");
            this.connectionRetriesInterval = json.getString("connectionRetriesInterval");
            this.save();
            return super.configure(req, json);
        }

        public FormValidation doCheckApiToken(@QueryParameter String apiToken) {
            return FormValidation.validateRequired((String)apiToken);
        }

        public FormValidation doCheckConnectionTimeout(@QueryParameter String connectionTimeout) {
            FormValidation formValidation = FormValidation.validatePositiveInteger((String)connectionTimeout);
            return formValidation;
        }

        public FormValidation doCheckConnectionRetries(@QueryParameter String connectionRetries) {
            FormValidation formValidation = FormValidation.validateNonNegativeInteger((String)connectionRetries);
            return formValidation;
        }

        public FormValidation doCheckConnectionRetriesInterval(@QueryParameter String connectionRetriesInterval) {
            FormValidation formValidation = FormValidation.validateNonNegativeInteger((String)connectionRetriesInterval);
            return formValidation;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getApiToken() {
            return this.apiToken;
        }

        public void setApiToken(String apiToken) {
            this.apiToken = apiToken;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public void setUserKey(String userKey) {
            this.userKey = userKey;
        }

        public String getCheckPolicies() {
            return this.pipelineCheckPolicies;
        }

        public void setCheckPolicies(String checkPolicies) {
            this.pipelineCheckPolicies = checkPolicies;
        }

        public boolean isFailOnError() {
            return this.failOnError;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public boolean isOverrideProxySettings() {
            return this.overrideProxySettings;
        }

        public void setOverrideProxySettings(boolean overrideProxySettings) {
            this.overrideProxySettings = overrideProxySettings;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(String connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public boolean isGlobalForceUpdate() {
            return this.globalForceUpdate;
        }

        public void setGlobalForceUpdate(boolean globalForceUpdate) {
            this.globalForceUpdate = globalForceUpdate;
        }

        public String getConnectionRetries() {
            return this.connectionRetries;
        }

        public void setConnectionRetries(String connectionRetries) {
            this.connectionRetries = connectionRetries;
        }

        public String getConnectionRetriesInterval() {
            return this.connectionRetriesInterval;
        }

        public void setConnectionRetriesInterval(String connectionRetriesInterval) {
            this.connectionRetriesInterval = connectionRetriesInterval;
        }
    }
}

