/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.model;

import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.whitesource.agent.FileSystemScanner;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.client.WhitesourceService;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.agent.report.PolicyCheckReport;
import org.whitesource.fs.FSAConfigProperties;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.jenkins.PolicyCheckReportAction;
import org.whitesource.jenkins.WhiteSourcePublisher;
import org.whitesource.jenkins.extractor.generic.GenericOssInfoExtractor;
import org.whitesource.jenkins.extractor.maven.MavenOssInfoExtractor;
import org.whitesource.jenkins.model.WhiteSourceDescriptor;
import org.whitesource.jenkins.pipeline.WhiteSourcePipelineStep;

public class WhiteSourceStep {
    public static final String SPACE = " ";
    private static final String PLUGIN_AGENTS_VERSION = "2.9.5";
    private static final String PLUGIN_VERSION = "19.1.1";
    public static final String WITH_MAVEN = "withMaven";
    public static final String GENERIC_GLOB_PATTERN = "**/*.";
    public static final String COMMA = ",";
    public static final String SLASH = "/";
    public static final String AGENT_KEYWORD = "agent";
    private WhiteSourceDescriptor globalConfig;
    private String jobApiToken;
    private String jobUserKey;
    private String product;
    private String productVersion;
    private String projectToken;
    private String libIncludes;
    private String libExcludes;
    private String mavenProjectToken;
    private String requesterEmail;
    private String moduleTokens;
    private String modulesToInclude;
    private String modulesToExclude;
    private boolean ignorePomModules;
    private String productNameOrToken;
    private boolean shouldCheckPolicies;
    private boolean checkAllLibraries;
    private boolean isForceUpdate;

    public WhiteSourceStep(WhiteSourceDescriptor globalConfig, String jobApiToken, String jobForceUpdate, String jobCheckPolicies, String jobUserKey) {
        this.globalConfig = globalConfig;
        this.setApiToken(jobApiToken);
        this.setUserKey(jobUserKey);
        this.isForceUpdate(jobForceUpdate);
        this.isCheckPolicies(jobCheckPolicies);
    }

    public WhiteSourceStep(WhiteSourcePublisher publisher, WhiteSourceDescriptor globalConfig) {
        this(globalConfig, publisher.getJobApiToken(), publisher.getJobForceUpdate(), publisher.getJobCheckPolicies(), publisher.getJobUserKey());
        this.product = publisher.getProduct();
        this.productVersion = publisher.getProductVersion();
        this.projectToken = publisher.getProjectToken();
        this.libIncludes = publisher.getLibIncludes();
        this.libExcludes = publisher.getLibExcludes();
        this.mavenProjectToken = publisher.getMavenProjectToken();
        this.requesterEmail = publisher.getRequesterEmail();
        this.moduleTokens = publisher.getModuleTokens();
        this.modulesToInclude = publisher.getModulesToInclude();
        this.modulesToExclude = publisher.getModulesToExclude();
        this.ignorePomModules = publisher.isIgnorePomModules();
    }

    public WhiteSourceStep(WhiteSourcePipelineStep step, WhiteSourceDescriptor globalConfig) {
        this(globalConfig, step.getJobApiToken(), step.getJobForceUpdate(), step.getJobCheckPolicies(), step.getJobUserKey());
        this.product = step.getProduct();
        this.productVersion = step.getProductVersion();
        this.projectToken = step.getProjectToken();
        this.libIncludes = step.getLibIncludes();
        this.libExcludes = step.getLibExcludes();
        this.requesterEmail = step.getRequesterEmail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Run<?, ?> run, TaskListener listener, Collection<AgentProjectInfo> projectInfos) {
        PrintStream logger = listener.getLogger();
        WhitesourceService service = this.createServiceClient(logger);
        try {
            if (this.shouldCheckPolicies) {
                logger.println("Checking policies");
                CheckPolicyComplianceRequest policyRequest = new CheckPolicyComplianceRequest(this.jobApiToken, projectInfos, this.checkAllLibraries);
                policyRequest.setProduct(this.productNameOrToken);
                policyRequest.setProductVersion(this.productVersion);
                policyRequest.setUserKey(this.jobUserKey);
                CheckPolicyComplianceResult result = service.checkPolicyCompliance(policyRequest);
                this.policyCheckReport(result, run, listener);
                boolean hasRejections = result.hasRejections();
                if (hasRejections && !this.isForceUpdate) {
                    String message = "Open source rejected by organization policies.";
                    if (this.globalConfig.isFailOnError()) {
                        this.stopBuild(run, listener, message);
                    } else {
                        logger.println(message);
                    }
                } else {
                    String message = hasRejections ? "Some dependencies violate open source policies, however all were force updated to organization inventory." : "All dependencies conform with open source policies.";
                    logger.println(message);
                    this.sendUpdate(this.jobApiToken, this.requesterEmail, this.productNameOrToken, projectInfos, service, logger, this.productVersion, this.jobUserKey);
                    if (this.globalConfig.isFailOnError() && hasRejections) {
                        this.stopBuild(run, listener, "White Source Publisher failure");
                    }
                }
            } else {
                this.sendUpdate(this.jobApiToken, this.requesterEmail, this.productNameOrToken, projectInfos, service, logger, this.productVersion, this.jobUserKey);
            }
        }
        catch (IOException | RuntimeException | WssServiceException e) {
            this.stopBuildOnError(run, this.globalConfig.isFailOnError(), listener, (Exception)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    public Collection<AgentProjectInfo> getProjectInfos(Run<?, ?> run, TaskListener listener, FilePath workspace, boolean isFreeStyleStep) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        logger.println("Collecting OSS usage information");
        Collection<Object> projectInfos = new LinkedList();
        this.productNameOrToken = this.product;
        if (run instanceof MavenModuleSetBuild) {
            projectInfos = this.getMavenProjectInfos((MavenModuleSetBuild)run, listener, workspace, logger);
        } else if (run instanceof FreeStyleBuild || isFreeStyleStep) {
            if (run instanceof WorkflowRun) {
                FlowExecution exec = ((WorkflowRun)run).getExecution();
                String script = "";
                if (exec != null) {
                    script = ((CpsFlowExecution)exec).getScript();
                }
                String withMavenChecker = script.replaceAll("(?sm)(^(?:\\s*)?((?:/\\*(?:\\*)?).*?(?<=\\*/))|(?://).*?(?<=$))", "");
                projectInfos = StringUtils.isNotBlank((String)script) && withMavenChecker.contains(WITH_MAVEN) ? this.getFSAProjects(logger, workspace) : this.getGenericProjectInfos(run, listener, workspace, logger);
            } else {
                projectInfos = this.getGenericProjectInfos(run, listener, workspace, logger);
            }
        }
        logger.println("Job finished.");
        return projectInfos;
    }

    private Collection<AgentProjectInfo> getMavenProjectInfos(MavenModuleSetBuild run, TaskListener listener, FilePath workspace, PrintStream logger) throws InterruptedException, IOException {
        logger.println("Starting Maven job on " + workspace.getRemote());
        MavenOssInfoExtractor extractor = new MavenOssInfoExtractor(this.modulesToInclude, this.modulesToExclude, run, listener, this.mavenProjectToken, this.moduleTokens, this.ignorePomModules);
        Collection<AgentProjectInfo> projectInfos = extractor.extract();
        if (StringUtils.isBlank((String)this.product)) {
            this.productNameOrToken = extractor.getTopMostProjectName();
        }
        return projectInfos;
    }

    private Collection<AgentProjectInfo> getGenericProjectInfos(Run<?, ?> run, TaskListener listener, FilePath workspace, PrintStream logger) throws InterruptedException, IOException {
        logger.println("Starting generic job on " + workspace.getRemote());
        GenericOssInfoExtractor extractor = new GenericOssInfoExtractor(this.libIncludes, this.libExcludes, run, listener, this.projectToken, workspace);
        Collection<AgentProjectInfo> projectInfos = extractor.extract();
        return projectInfos;
    }

    public void stopBuild(Run<?, ?> run, TaskListener listener, String message) {
        listener.error(message);
        run.setResult(Result.FAILURE);
    }

    private WhitesourceService createServiceClient(PrintStream logger) {
        String url = this.globalConfig.getServiceUrl();
        logger.println("WhiteSource Service URL:" + url);
        if (StringUtils.isNotBlank((String)url) && !url.endsWith(AGENT_KEYWORD)) {
            if (!url.endsWith(SLASH)) {
                url = url + SLASH;
            }
            url = url + AGENT_KEYWORD;
        }
        int connectionTimeout = 60;
        if (NumberUtils.isNumber((String)this.globalConfig.getConnectionTimeout())) {
            int connectionTimeoutInteger = Integer.parseInt(this.globalConfig.getConnectionTimeout());
            connectionTimeout = connectionTimeoutInteger > 0 ? connectionTimeoutInteger : connectionTimeout;
        }
        boolean proxyConfigured = this.isProxyConfigured(this.globalConfig);
        WhitesourceService service = new WhitesourceService("jenkins", PLUGIN_AGENTS_VERSION, PLUGIN_VERSION, url, proxyConfigured, connectionTimeout);
        if (proxyConfigured) {
            String password;
            String userName;
            int port;
            String host;
            if (this.globalConfig.isOverrideProxySettings()) {
                host = this.globalConfig.getServer();
                port = StringUtils.isBlank((String)this.globalConfig.getPort()) ? 0 : Integer.parseInt(this.globalConfig.getPort());
                userName = this.globalConfig.getUserName();
                password = this.globalConfig.getPassword();
            } else {
                Hudson hudsonInstance = Hudson.getInstance();
                if (hudsonInstance == null) {
                    throw new RuntimeException("Failed to acquire Hudson Instance");
                }
                ProxyConfiguration proxy = hudsonInstance.proxy;
                host = proxy.name;
                port = proxy.port;
                userName = proxy.getUserName();
                password = proxy.getPassword();
            }
            try {
                URL tmpUrl = new URL(host);
                host = tmpUrl.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            service.getClient().setProxy(host, port, userName, password);
        }
        return service;
    }

    private void sendUpdate(String orgToken, String requesterEmail, String productNameOrToken, Collection<AgentProjectInfo> projectInfos, WhitesourceService service, PrintStream logger, String productVersion, String userKey) throws WssServiceException {
        logger.println("Sending to White Source");
        int retries = Integer.parseInt(this.globalConfig.getConnectionRetries());
        int interval = Integer.parseInt(this.globalConfig.getConnectionRetriesInterval());
        UpdateInventoryResult updateResult = null;
        while (retries-- > -1) {
            try {
                UpdateInventoryRequest updateRequest = new UpdateInventoryRequest(orgToken, productNameOrToken, productVersion, projectInfos, userKey, null);
                updateRequest.setRequesterEmail(requesterEmail);
                updateResult = service.update(updateRequest);
                if (updateResult == null) continue;
                break;
            }
            catch (WssServiceException e) {
                logger.println("Failed to send request to WhiteSource server: " + e.getMessage());
                if (e.getCause() != null && e.getCause().getClass().getCanonicalName().substring(0, e.getCause().getClass().getCanonicalName().lastIndexOf(".")).equals("java.net")) {
                    logger.println("Trying " + (retries + 1) + " more time" + (retries != 0 ? "s" : ""));
                } else {
                    retries = -1;
                }
                if (retries <= -1) continue;
                try {
                    Thread.sleep(interval * 1000);
                }
                catch (InterruptedException e1) {
                    logger.println("Failed to sleep while retrying to connect to server " + e1.getMessage());
                }
            }
        }
        if (updateResult == null) {
            throw new WssServiceException("Connection Failed");
        }
        this.logUpdateResult(updateResult, logger);
    }

    private void stopBuildOnError(Run<?, ?> run, boolean failOnError, TaskListener listener, Exception e) {
        String requestToken;
        if (e instanceof IOException) {
            Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
        }
        listener.error("White Source Publisher failure " + e.getMessage());
        if (failOnError) {
            run.setResult(Result.FAILURE);
        }
        if (e instanceof WssServiceException && StringUtils.isNotBlank((String)(requestToken = ((WssServiceException)((Object)e)).getRequestToken()))) {
            listener.getLogger().println("Support Token: " + requestToken);
        }
    }

    private void policyCheckReport(CheckPolicyComplianceResult result, Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Generating policy check report");
        PolicyCheckReport report = new PolicyCheckReport((BaseCheckPoliciesResult)result, run.getParent().getName(), Integer.toString(run.getNumber()));
        report.generate(run.getRootDir(), false);
        run.addAction((Action)new PolicyCheckReportAction(run));
    }

    private void setApiToken(String jobApiToken) {
        this.jobApiToken = StringUtils.isNotBlank((String)jobApiToken) ? jobApiToken : this.globalConfig.getApiToken();
    }

    private void setUserKey(String jobUerKey) {
        this.jobUserKey = StringUtils.isNotBlank((String)jobUerKey) ? jobUerKey : this.globalConfig.getUserKey();
    }

    private void isCheckPolicies(String jobCheckPolicies) {
        if (StringUtils.isBlank((String)jobCheckPolicies) || "global".equals(jobCheckPolicies)) {
            String checkPolicies = this.globalConfig.getCheckPolicies();
            this.shouldCheckPolicies = "enableNew".equals(checkPolicies) || "enableAll".equals(checkPolicies);
            this.checkAllLibraries = "enableAll".equals(checkPolicies);
        } else {
            this.shouldCheckPolicies = "enableNew".equals(jobCheckPolicies) || "enableAll".equals(jobCheckPolicies);
            this.checkAllLibraries = "enableAll".equals(jobCheckPolicies);
        }
    }

    private void isForceUpdate(String jobForceUpdate) {
        this.isForceUpdate = StringUtils.isBlank((String)jobForceUpdate) || "global".equals(jobForceUpdate) ? this.globalConfig.isGlobalForceUpdate() : "forceUpdate".equals(jobForceUpdate);
    }

    private boolean isProxyConfigured(WhiteSourceDescriptor globalConfig) {
        Hudson hudsonInstance = Hudson.getInstance();
        return globalConfig.isOverrideProxySettings() || hudsonInstance != null && hudsonInstance.proxy != null;
    }

    private void logUpdateResult(UpdateInventoryResult result, PrintStream logger) {
        logger.println("WhiteSource update results: ");
        logger.println("WhiteSource organization: " + result.getOrganization());
        logger.println(result.getCreatedProjects().size() + " Newly created projects:");
        logger.println(StringUtils.join((Collection)result.getCreatedProjects(), (String)COMMA));
        logger.println(result.getUpdatedProjects().size() + " existing projects were updated:");
        logger.println(StringUtils.join((Collection)result.getUpdatedProjects(), (String)COMMA));
        String requestToken = result.getRequestToken();
        if (StringUtils.isNotBlank((String)requestToken)) {
            logger.println("WhiteSource Support Token: " + requestToken);
        }
    }

    private String getResource(String propertyName, PrintStream logger) {
        Properties properties = this.getProperties(logger);
        String val = properties.getProperty(propertyName);
        if (StringUtils.isNotBlank((String)val)) {
            return val;
        }
        return "";
    }

    private Properties getProperties(PrintStream logger) {
        Properties properties = new Properties();
        try (InputStream stream = WhiteSourceStep.class.getResourceAsStream("/project.properties");){
            properties.load(stream);
        }
        catch (IOException e) {
            logger.println("White Source update results: ");
        }
        return properties;
    }

    public WhiteSourceDescriptor getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(WhiteSourceDescriptor globalConfig) {
        this.globalConfig = globalConfig;
    }

    public String getJobApiToken() {
        return this.jobApiToken;
    }

    public void setJobApiToken(String jobApiToken) {
        this.jobApiToken = jobApiToken;
    }

    public String getJobUserKey() {
        return this.jobUserKey;
    }

    public void setJobUserKey(String jobUserKey) {
        this.jobUserKey = jobUserKey;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProjectToken() {
        return this.projectToken;
    }

    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    public String getLibIncludes() {
        return this.libIncludes;
    }

    public void setLibIncludes(String libIncludes) {
        this.libIncludes = libIncludes;
    }

    public String getLibExcludes() {
        return this.libExcludes;
    }

    public void setLibExcludes(String libExcludes) {
        this.libExcludes = libExcludes;
    }

    public String getMavenProjectToken() {
        return this.mavenProjectToken;
    }

    public void setMavenProjectToken(String mavenProjectToken) {
        this.mavenProjectToken = mavenProjectToken;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    public void setRequesterEmail(String requesterEmail) {
        this.requesterEmail = requesterEmail;
    }

    public String getModuleTokens() {
        return this.moduleTokens;
    }

    public void setModuleTokens(String moduleTokens) {
        this.moduleTokens = moduleTokens;
    }

    public String getModulesToInclude() {
        return this.modulesToInclude;
    }

    public void setModulesToInclude(String modulesToInclude) {
        this.modulesToInclude = modulesToInclude;
    }

    public String getModulesToExclude() {
        return this.modulesToExclude;
    }

    public void setModulesToExclude(String modulesToExclude) {
        this.modulesToExclude = modulesToExclude;
    }

    public boolean isIgnorePomModules() {
        return this.ignorePomModules;
    }

    public void setIgnorePomModules(boolean ignorePomModules) {
        this.ignorePomModules = ignorePomModules;
    }

    public String getProductNameOrToken() {
        return this.productNameOrToken;
    }

    public void setProductNameOrToken(String productNameOrToken) {
        this.productNameOrToken = productNameOrToken;
    }

    public boolean isShouldCheckPolicies() {
        return this.shouldCheckPolicies;
    }

    public void setShouldCheckPolicies(boolean shouldCheckPolicies) {
        this.shouldCheckPolicies = shouldCheckPolicies;
    }

    public boolean isCheckAllLibraries() {
        return this.checkAllLibraries;
    }

    public void setCheckAllLibraries(boolean checkAllLibraries) {
        this.checkAllLibraries = checkAllLibraries;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.isForceUpdate = forceUpdate;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public void initializeIncludes() {
        LinkedList<String> includes = new LinkedList<String>();
        if (CollectionUtils.isEmpty(includes)) {
            for (String extension : GenericOssInfoExtractor.DEFAULT_SCAN_EXTENSIONS) {
                includes.add(GENERIC_GLOB_PATTERN + extension);
            }
        }
        this.libIncludes = String.join((CharSequence)COMMA, includes);
    }

    public Collection<AgentProjectInfo> getFSAProjects(PrintStream logger, FilePath workspace) {
        ArrayList<AgentProjectInfo> projects = new ArrayList<AgentProjectInfo>();
        Map fsaProjects = Collections.emptyMap();
        logger.println("Starting Pipeline-FSA job on " + workspace.getRemote());
        FSAConfigProperties props = new FSAConfigProperties();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(workspace.getRemote());
        props.put((Object)"maven.aggregateModules", (Object)"false");
        FSAConfiguration fsaConfiguration = new FSAConfiguration(props);
        if (StringUtils.isEmpty((String)this.libIncludes)) {
            this.initializeIncludes();
            this.libIncludes = this.libIncludes.replaceAll(COMMA, SPACE);
        }
        HashMap appPathsToDependencyDirs = new HashMap();
        HashSet set = new HashSet();
        appPathsToDependencyDirs.put("defaultKey", set);
        ((Set)appPathsToDependencyDirs.get("defaultKey")).add(workspace.getRemote());
        try {
            FileSystemScanner fileSystemScanner = new FileSystemScanner(fsaConfiguration.getResolver(), fsaConfiguration.getAgent(), false);
            fsaProjects = fileSystemScanner.createProjects(paths, appPathsToDependencyDirs, false, this.libIncludes.split(SPACE), this.libExcludes.split(COMMA), false, 0, null, null, false, false, null, false, false, false, ArrayUtils.EMPTY_STRING_ARRAY);
            int dependencyCount = 0;
            for (AgentProjectInfo agentProjectInfo : fsaProjects.keySet()) {
                dependencyCount += agentProjectInfo.getDependencies().size();
            }
            logger.println("Found " + dependencyCount + " dependencies .");
        }
        catch (Exception ex) {
            for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
                logger.println("Error getting FSA dependencies " + stackTraceElement.toString());
            }
        }
        for (AgentProjectInfo agentProjectInfo : fsaProjects.keySet()) {
            if (this.projectToken != null && StringUtils.isNotBlank((String)this.projectToken)) {
                agentProjectInfo.setProjectToken(this.projectToken);
            } else if (agentProjectInfo.getCoordinates() != null) {
                agentProjectInfo.setCoordinates(new Coordinates(null, agentProjectInfo.getCoordinates().getArtifactId(), this.productVersion));
            } else {
                agentProjectInfo.setCoordinates(new Coordinates(null, this.productNameOrToken, this.productVersion));
            }
            projects.add(agentProjectInfo);
        }
        return projects;
    }
}

