/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.whitesource.agent.api.model.ChecksumType;
import org.whitesource.agent.api.model.DependencyInfo;

public class RemoteDependency
implements Serializable {
    private String systemPath;
    private String artifactId;
    private String sha1;
    private Map<ChecksumType, String> checksums = new HashMap<ChecksumType, String>();
    private String otherPlatformSha1;
    private String fullHash;
    private String mostSigBitsHash;
    private String groupId;
    private String version;
    private String type;
    private String classifier;
    private String scope;
    private String leastSigBitsHash;

    public static Collection<DependencyInfo> convert(Collection<RemoteDependency> remoteDependencies) {
        ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
        for (RemoteDependency remoteDependency : remoteDependencies) {
            DependencyInfo dependencyInfo = new DependencyInfo();
            dependencyInfo.setSystemPath(remoteDependency.getSystemPath());
            dependencyInfo.setArtifactId(remoteDependency.getArtifactId());
            dependencyInfo.setSha1(remoteDependency.getSha1());
            dependencyInfo.setChecksums(remoteDependency.getChecksums());
            dependencyInfo.setOtherPlatformSha1(remoteDependency.getOtherPlatformSha1());
            dependencyInfo.setFullHash(remoteDependency.getFullHash());
            dependencyInfo.setMostSigBitsHash(remoteDependency.getMostSigBitsHash());
            dependencyInfo.setLeastSigBitsHash(remoteDependency.getLeastSigBitsHash());
            dependencyInfo.setGroupId(remoteDependency.getGroupId());
            dependencyInfo.setVersion(remoteDependency.getVersion());
            dependencyInfo.setType(remoteDependency.getType());
            dependencyInfo.setClassifier(remoteDependency.getClassifier());
            dependencyInfo.setScope(remoteDependency.getScope());
            dependencies.add(dependencyInfo);
        }
        return dependencies;
    }

    public Map<ChecksumType, String> getChecksums() {
        return this.checksums;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public void setOtherPlatformSha1(String otherPlatformSha1) {
        this.otherPlatformSha1 = otherPlatformSha1;
    }

    public String getOtherPlatformSha1() {
        return this.otherPlatformSha1;
    }

    public void setFullHash(String fullHash) {
        this.fullHash = fullHash;
    }

    public String getFullHash() {
        return this.fullHash;
    }

    public void setMostSigBitsHash(String mostSigBitsHash) {
        this.mostSigBitsHash = mostSigBitsHash;
    }

    public String getMostSigBitsHash() {
        return this.mostSigBitsHash;
    }

    public void setLeastSigBitsHash(String leastSigBitsHash) {
        this.leastSigBitsHash = leastSigBitsHash;
    }

    public String getLeastSigBitsHash() {
        return this.leastSigBitsHash;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

