/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.extractor.maven;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.jenkins.WssUtils;
import org.whitesource.jenkins.extractor.BaseOssInfoExtractor;
import org.whitesource.jenkins.extractor.maven.MavenDependenciesRecord;
import org.whitesource.jenkins.model.RemoteDependency;

public class MavenOssInfoExtractor
extends BaseOssInfoExtractor {
    private final MavenModuleSetBuild mavenModuleSetBuild;
    private final String mavenProjectToken;
    private final Map<String, String> moduleTokens;
    private final boolean ignorePomModules;

    public MavenOssInfoExtractor(String includes, String excludes, MavenModuleSetBuild mavenModuleSetBuild, TaskListener listener, String mavenProjectToken, String moduleTokens, boolean ignorePomModules) {
        super(includes, excludes, (Run<?, ?>)mavenModuleSetBuild, listener);
        this.mavenModuleSetBuild = mavenModuleSetBuild;
        this.mavenProjectToken = mavenProjectToken;
        this.ignorePomModules = ignorePomModules;
        this.moduleTokens = WssUtils.splitParametersMap(moduleTokens);
    }

    @Override
    public Collection<AgentProjectInfo> extract() throws InterruptedException, IOException {
        PrintStream logger = this.listener.getLogger();
        ArrayList<AgentProjectInfo> projectInfos = new ArrayList<AgentProjectInfo>();
        Map moduleLastBuilds = this.mavenModuleSetBuild.getModuleLastBuilds();
        for (Map.Entry entry : moduleLastBuilds.entrySet()) {
            MavenBuild moduleBuild = (MavenBuild)entry.getValue();
            MavenArtifactRecord action = (MavenArtifactRecord)moduleBuild.getAction(MavenArtifactRecord.class);
            if (this.shouldProcess(action)) {
                logger.println("Processing " + action.pomArtifact.canonicalName);
                AgentProjectInfo projectInfo = new AgentProjectInfo();
                projectInfo.setCoordinates(new Coordinates(action.mainArtifact.groupId, action.mainArtifact.artifactId, action.mainArtifact.version));
                projectInfo.setParentCoordinates(new Coordinates(action.pomArtifact.groupId, action.pomArtifact.artifactId, action.pomArtifact.version));
                if (moduleLastBuilds.size() == 1) {
                    projectInfo.setProjectToken(this.mavenProjectToken);
                } else {
                    projectInfo.setProjectToken(this.moduleTokens.get(action.mainArtifact.artifactId));
                }
                Collection dependencyInfos = projectInfo.getDependencies();
                MavenDependenciesRecord dependenciesAction = (MavenDependenciesRecord)moduleBuild.getAction(MavenDependenciesRecord.class);
                if (dependenciesAction == null) {
                    logger.println("No dependencies found.");
                } else {
                    Set<RemoteDependency> dependencies = dependenciesAction.getDependencies();
                    dependencyInfos.addAll(RemoteDependency.convert(dependencies));
                    logger.println("Found " + dependencies.size() + " dependencies (transitive included)");
                }
                projectInfos.add(projectInfo);
                continue;
            }
            logger.println("Skipping module: " + ((MavenModule)moduleBuild.getProject()).getDisplayName());
        }
        return projectInfos;
    }

    public String getTopMostProjectName() {
        MavenModule rootModule = this.mavenModuleSetBuild.getParent().getRootModule();
        String name = rootModule.getDisplayName();
        return StringUtils.isBlank((String)name) ? rootModule.getModuleName().artifactId : name;
    }

    private boolean shouldProcess(MavenArtifactRecord action) {
        if (action == null) {
            return false;
        }
        boolean process = this.includes.isEmpty();
        String artifactId = action.mainArtifact.artifactId;
        String type = action.mainArtifact.type;
        if (this.ignorePomModules && "pom".equals(type)) {
            process = false;
        } else if (!this.excludes.isEmpty() && this.matchAny(artifactId, this.excludes)) {
            process = false;
        } else if (!this.includes.isEmpty() && this.matchAny(artifactId, this.includes)) {
            process = true;
        }
        return process;
    }

    private boolean matchAny(String value, List<String> patterns) {
        boolean match = false;
        Iterator<String> it = patterns.iterator();
        while (it.hasNext() && !match) {
            String regex = it.next().replace(".", "\\.").replace("*", ".*");
            match = value.matches(regex);
        }
        return match;
    }
}

