/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins.extractor.generic;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.ChecksumType;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.hash.FileExtensions;
import org.whitesource.agent.hash.HashCalculationResult;
import org.whitesource.agent.hash.HashCalculator;
import org.whitesource.jenkins.model.RemoteDependency;

public class LibFolderScanner
extends MasterToSlaveFileCallable<Collection<RemoteDependency>> {
    private static final long serialVersionUID = 6773794529916357187L;
    private static final String JAVA_SCRIPT_REGEX = ".*\\.js";
    public static final String EMPTY_STRING = "";
    private List<String> libIncludes;
    private List<String> libExcludes;
    private TaskListener listener;
    private Collection<RemoteDependency> dependencies;

    public LibFolderScanner(List<String> libIncludes, List<String> libExcludes, TaskListener listener) {
        this.libIncludes = libIncludes;
        this.libExcludes = libExcludes;
        this.listener = listener;
        this.dependencies = new ArrayList<RemoteDependency>();
    }

    public Collection<RemoteDependency> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        FilePath[] libraries;
        this.listener.getLogger().println("Scanning folder " + f.getName());
        String includes = StringUtils.join(this.libIncludes, (String)",");
        String excludes = StringUtils.join(this.libExcludes, (String)",");
        for (FilePath file : libraries = new FilePath(f).list(includes, excludes)) {
            try {
                this.dependencies.add(this.collectDependencyInfo(file));
            }
            catch (IOException e) {
                this.listener.getLogger().println("Error extracting library details");
            }
        }
        this.listener.getLogger().println("Found " + this.dependencies.size() + " dependencies matching include / exclude pattern in folder.");
        return this.dependencies;
    }

    private RemoteDependency collectDependencyInfo(FilePath file) throws IOException, InterruptedException {
        RemoteDependency info = new RemoteDependency();
        info.setSystemPath(file.getRemote());
        info.setArtifactId(file.getName());
        info.setSha1((String)file.act((FilePath.FileCallable)new CalcSha1FileCallable()));
        this.calculateHashes(new File(file.getRemote()), info);
        return info;
    }

    private void calculateHashes(File file, RemoteDependency info) {
        if (file.getName().toLowerCase().matches(JAVA_SCRIPT_REGEX)) {
            Map javaScriptChecksums = new HashMap();
            try {
                javaScriptChecksums = new HashCalculator().calculateJavaScriptHashes(file);
            }
            catch (Exception e) {
                this.listener.getLogger().println("Failed to calculate javaScript file hash for :" + file.getName());
            }
            for (Map.Entry entry : javaScriptChecksums.entrySet()) {
                info.getChecksums().put((ChecksumType)entry.getKey(), (String)entry.getValue());
            }
        }
        String otherPlatformSha1 = ChecksumUtils.calculateOtherPlatformSha1((File)file);
        info.setOtherPlatformSha1(otherPlatformSha1);
        HashCalculator superHashCalculator = new HashCalculator();
        if (!file.getName().toLowerCase().matches(FileExtensions.BINARY_FILE_EXTENSION_REGEX)) {
            try {
                HashCalculationResult superHashResult = superHashCalculator.calculateSuperHash(file);
                if (superHashResult != null) {
                    info.setFullHash(superHashResult.getFullHash());
                    info.setMostSigBitsHash(superHashResult.getMostSigBitsHash());
                    info.setLeastSigBitsHash(superHashResult.getLeastSigBitsHash());
                }
            }
            catch (IOException err) {
                this.listener.getLogger().println("Error calculating fullHash for {}, Error - " + file.getName() + err.getMessage());
            }
        }
    }

    static class CalcSha1FileCallable
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = 2959979211787869074L;

        CalcSha1FileCallable() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return ChecksumUtils.calculateSHA1((File)f);
        }
    }
}

