/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.jenkins;

import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.tasks.Maven;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class WssUtils {
    private static final Pattern PARAM_LIST_SPLIT_PATTERN = Pattern.compile(",|$| ", 8);
    private static final Pattern KEY_VALUE_SPLIT_PATTERN = Pattern.compile("=");

    private WssUtils() {
    }

    public static boolean isMaven(AbstractProject<?, ?> project) {
        return project instanceof MavenModuleSet;
    }

    public static boolean isFreeStyle(AbstractProject<?, ?> project) {
        return project instanceof FreeStyleProject && !WssUtils.isFreeStyleMaven(project);
    }

    public static boolean isFreeStyleMaven(Job<?, ?> job) {
        boolean freeStyle = false;
        if (job instanceof FreeStyleProject) {
            Iterator it = ((FreeStyleProject)job).getBuilders().iterator();
            while (it.hasNext() && !freeStyle) {
                freeStyle = it.next() instanceof Maven;
            }
        }
        return freeStyle;
    }

    public static String selectedCheckPolicies(String value) {
        String selectedCheckPolicies = "global";
        if (StringUtils.isNotBlank((String)value)) {
            selectedCheckPolicies = value;
        }
        return selectedCheckPolicies;
    }

    public static String selectedForceUpdate(String value) {
        String selectedForceUpdate = "global";
        if (StringUtils.isNotBlank((String)value)) {
            selectedForceUpdate = value;
        }
        return selectedForceUpdate;
    }

    public static String selectedGlobalCheckPolicies(String value) {
        String globalCheckedPolicies = "disable";
        if (StringUtils.isNotBlank((String)value)) {
            globalCheckedPolicies = value;
        }
        return globalCheckedPolicies;
    }

    public static List<String> splitParameters(String paramList) {
        String[] split;
        ArrayList<String> params = new ArrayList<String>();
        if (paramList != null && (split = PARAM_LIST_SPLIT_PATTERN.split(paramList)) != null) {
            for (String param : split) {
                if (!StringUtils.isNotBlank((String)param)) continue;
                params.add(param.trim());
            }
        }
        return params;
    }

    public static Map<String, String> splitParametersMap(String paramList) {
        HashMap<String, String> params = new HashMap<String, String>();
        List<String> kvps = WssUtils.splitParameters(paramList);
        if (kvps != null) {
            for (String kvp : kvps) {
                String[] split = KEY_VALUE_SPLIT_PATTERN.split(kvp);
                if (split.length != 2) continue;
                params.put(split[0], split[1]);
            }
        }
        return params;
    }
}

