/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.ApiRateLimits;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateLimitStatus
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -3153374766679996576L;
    private int ipLimit;
    private int remainingIpHits;
    private long remainingUserHits;
    private String resetTime;
    private int resetTimeInSeconds;
    private long userLimit;
    private List<ApiRateLimits> apiRateLimit;

    public RateLimitStatus(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONArray list = json.getJSONArray("api_rate_limits");
            int size = list.length();
            this.apiRateLimit = new ArrayList<ApiRateLimits>(size);
            for (int i = 0; i < size; ++i) {
                this.apiRateLimit.add(new ApiRateLimits(list.getJSONObject(i)));
            }
            this.ipLimit = json.getInt("ip_limit");
            this.remainingIpHits = json.getInt("remaining_ip_hits");
            this.remainingUserHits = json.getLong("remaining_user_hits");
            this.resetTime = json.getString("reset_time");
            this.resetTimeInSeconds = json.getInt("reset_time_in_seconds");
            this.userLimit = json.getLong("user_limit");
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    public int getIpLimit() {
        return this.ipLimit;
    }

    public void setIpLimit(int ipLimit) {
        this.ipLimit = ipLimit;
    }

    public int getRemainingIpHits() {
        return this.remainingIpHits;
    }

    public void setRemainingIpHits(int remainingIpHits) {
        this.remainingIpHits = remainingIpHits;
    }

    public long getRemainingUserHits() {
        return this.remainingUserHits;
    }

    public void setRemainingUserHits(long remainingUserHits) {
        this.remainingUserHits = remainingUserHits;
    }

    public String getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(String resetTime) {
        this.resetTime = resetTime;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public void setResetTimeInSeconds(int resetTimeInSeconds) {
        this.resetTimeInSeconds = resetTimeInSeconds;
    }

    public long getUserLimit() {
        return this.userLimit;
    }

    public void setUserLimit(long userLimit) {
        this.userLimit = userLimit;
    }

    public List<ApiRateLimits> getApiRateLimit() {
        return this.apiRateLimit;
    }

    public void setApiRateLimit(List<ApiRateLimits> apiRateLimit) {
        this.apiRateLimit = apiRateLimit;
    }

    public String toString() {
        return "RateLimitStatus [ipLimit=" + this.ipLimit + ", remainingIpHits=" + this.remainingIpHits + ", remainingUserHits=" + this.remainingUserHits + ", resetTime=" + this.resetTime + ", resetTimeInSeconds=" + this.resetTimeInSeconds + ", userLimit=" + this.userLimit + ", apiRateLimit=" + this.apiRateLimit + "]";
    }
}

