/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.List;
import weibo4j.Weibo;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.Trends;
import weibo4j.model.UserTrend;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trend
extends Weibo {
    private static final long serialVersionUID = 903299515334415487L;

    public List<UserTrend> getTrends(String uid) throws WeiboException {
        return UserTrend.constructTrendList(this.client.get(WeiboConfig.getValue("baseURL") + "trends.json", new PostParameter[]{new PostParameter("uid", uid)}));
    }

    public List<UserTrend> getTrends(String uid, Paging page) throws WeiboException {
        return UserTrend.constructTrendList(this.client.get(WeiboConfig.getValue("baseURL") + "trends.json", new PostParameter[]{new PostParameter("uid", uid)}, page));
    }

    public JSONObject isFollow(String trend_name) throws WeiboException {
        return this.client.get(WeiboConfig.getValue("baseURL") + "trends/is_follow.json", new PostParameter[]{new PostParameter("trend_name", trend_name)}).asJSONObject();
    }

    public List<Trends> getTrendsHourly() throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/hourly.json"));
    }

    public List<Trends> getTrendsHourly(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/hourly.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}));
    }

    public List<Trends> getTrendsDaily() throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/daily.json"));
    }

    public List<Trends> getTrendsDaily(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/daily.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}));
    }

    public List<Trends> getTrendsWeekly() throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/weekly.json"));
    }

    public List<Trends> getTrendsWeekly(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(this.client.get(WeiboConfig.getValue("baseURL") + "trends/weekly.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}));
    }

    public UserTrend trendsFollow(String trend_name) throws WeiboException {
        return new UserTrend(this.client.post(WeiboConfig.getValue("baseURL") + "trends/follow.json", new PostParameter[]{new PostParameter("trend_name", trend_name)}));
    }

    public JSONObject trendsDestroy(Integer trend_id) throws WeiboException {
        return this.client.post(WeiboConfig.getValue("baseURL") + "trends/destroy.json", new PostParameter[]{new PostParameter("trend_id", trend_id.toString())}).asJSONObject();
    }
}

