/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import weibo4j.Weibo;
import weibo4j.model.Comment;
import weibo4j.model.CommentWapper;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.util.WeiboConfig;

public class Comments
extends Weibo {
    private static final long serialVersionUID = 3321231200237418256L;

    public CommentWapper getCommentById(String id) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/show.json", new PostParameter[]{new PostParameter("id", id)}));
    }

    public CommentWapper getCommentById(String id, Paging page, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/show.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("filter_by_author", filter_by_author.toString())}, page));
    }

    public CommentWapper getCommentByMe() throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/by_me.json"));
    }

    public CommentWapper getCommentByMe(Paging page, Integer filter_by_source) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/by_me.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_source.toString())}, page));
    }

    public CommentWapper getCommentToMe() throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/to_me.json"));
    }

    public CommentWapper getCommentToMe(Paging page, Integer filter_by_source, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/to_me.json", new PostParameter[]{new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_author", filter_by_author.toString())}, page));
    }

    public CommentWapper getCommentTimeline() throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/timeline.json"));
    }

    public CommentWapper getCommentTimeline(Paging page) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/timeline.json", null, page));
    }

    public CommentWapper getCommentMentions() throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/mentions.json"));
    }

    public CommentWapper getCommentMentions(Paging page, Integer filter_by_source, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(this.client.get(WeiboConfig.getValue("baseURL") + "comments/mentions.json", new PostParameter[]{new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_author", filter_by_author.toString())}, page));
    }

    public JSONArray getCommentShowBatch(String cids) throws WeiboException {
        return this.client.get(WeiboConfig.getValue("baseURL") + "comments/show_batch.json", new PostParameter[]{new PostParameter("cids", cids)}).asJSONArray();
    }

    public Comment createComment(String comment, String id) throws WeiboException {
        return new Comment(this.client.post(WeiboConfig.getValue("baseURL") + "comments/create.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id)}));
    }

    public Comment createComment(String comment, String id, Integer comment_ori) throws WeiboException {
        return new Comment(this.client.post(WeiboConfig.getValue("baseURL") + "comments/create.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id), new PostParameter("comment_ori", comment_ori.toString())}));
    }

    public Comment replyComment(String cid, String id, String comment) throws WeiboException {
        return new Comment(this.client.post(WeiboConfig.getValue("baseURL") + "comments/reply.json", new PostParameter[]{new PostParameter("cid", cid), new PostParameter("id", id), new PostParameter("comment", comment)}));
    }

    public Comment replyComment(String cid, String id, String comment, Integer without_mention, Integer comment_ori) throws WeiboException {
        return new Comment(this.client.post(WeiboConfig.getValue("baseURL") + "comments/reply.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id), new PostParameter("cid", cid), new PostParameter("without_mention", without_mention.toString()), new PostParameter("comment_ori", comment_ori.toString())}));
    }

    public Comment destroyComment(String cid) throws WeiboException {
        return new Comment(this.client.post(WeiboConfig.getValue("baseURL") + "comments/destroy.json", new PostParameter[]{new PostParameter("cid", cid)}));
    }

    public JSONArray destoryCommentBatch(String cids) throws WeiboException {
        return this.client.post(WeiboConfig.getValue("baseURL") + "comments/destroy_batch.json", new PostParameter[]{new PostParameter("cids", cids)}).asJSONArray();
    }
}

