/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.websphere_deployer;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.websphere.services.deployment.Artifact;
import org.jenkinsci.plugins.websphere.services.deployment.LibertyDeploymentService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class LibertyDeployerPlugin
extends Notifier {
    private final String ipAddress;
    private final String port;
    private final String username;
    private final String consolePassword;
    private final String clientTrustFile;
    private final String clientTrustPassword;
    private final String artifacts;

    @DataBoundConstructor
    public LibertyDeployerPlugin(String ipAddress, String port, String username, String consolePassword, String clientTrustFile, String clientTrustPassword, String artifacts) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.username = username;
        this.consolePassword = Scrambler.scramble((String)consolePassword);
        this.clientTrustFile = clientTrustFile;
        this.clientTrustPassword = Scrambler.scramble((String)clientTrustPassword);
        this.artifacts = artifacts;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getConsolePassword() {
        return Scrambler.descramble((String)this.consolePassword);
    }

    public String getClientTrustFile() {
        return this.clientTrustFile;
    }

    public String getClientTrustPassword() {
        return Scrambler.descramble((String)this.clientTrustPassword);
    }

    public String getArtifacts() {
        return this.artifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Result buildResult = build.getResult();
        if (buildResult == null) {
            listener.getLogger().println("Error deploying to IBM WebSphere Liberty Profile: Build result is null");
            throw new IllegalStateException("Build result is null");
        }
        if (buildResult.equals(Result.SUCCESS)) {
            LibertyDeploymentService service = new LibertyDeploymentService();
            try {
                this.connect(listener, service);
                for (FilePath path : this.gatherArtifactPaths(build, listener)) {
                    Artifact artifact = this.createArtifact(path, listener);
                    this.stopArtifact(artifact, listener, service);
                    this.uninstallArtifact(artifact, listener, service);
                    this.deployArtifact(artifact, listener, service);
                    Thread.sleep(2000L);
                    this.startArtifact(artifact, listener, service);
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (PrintStream p = null;){
                    p = new PrintStream((OutputStream)out, true, "UTF-8");
                    e.printStackTrace(p);
                    listener.getLogger().println("Error deploying to IBM WebSphere Liberty Profile: " + new String(out.toByteArray(), "UTF-8"));
                    build.setResult(Result.FAILURE);
                }
            }
            finally {
                try {
                    this.disconnect(listener, service);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private Artifact createArtifact(FilePath path, BuildListener listener) {
        Artifact artifact = new Artifact();
        if (path.getRemote().endsWith(".ear")) {
            artifact.setType(1);
        } else if (path.getRemote().endsWith(".war")) {
            artifact.setType(2);
        } else if (path.getRemote().endsWith(".rar")) {
            artifact.setType(4);
        } else if (path.getRemote().endsWith(".jar")) {
            artifact.setType(3);
        }
        artifact.setSourcePath(new File(path.getRemote()));
        artifact.setAppName(path.getBaseName());
        return artifact;
    }

    private void connect(BuildListener listener, LibertyDeploymentService service) throws Exception {
        listener.getLogger().println("Connecting to IBM WebSphere Liberty Profile...");
        service.setHost(this.getIpAddress());
        service.setPort(this.getPort());
        service.setUsername(this.getUsername());
        service.setPassword(this.getConsolePassword());
        service.setTrustStoreLocation(new File(this.getClientTrustFile()));
        service.setTrustStorePassword(this.getClientTrustPassword());
        service.connect();
    }

    private void disconnect(BuildListener listener, LibertyDeploymentService service) throws Exception {
        listener.getLogger().println("Disconnecting from IBM WebSphere Liberty Profile...");
        service.disconnect();
    }

    private void stopArtifact(Artifact artifact, BuildListener listener, LibertyDeploymentService service) throws Exception {
        if (service.isArtifactInstalled(artifact)) {
            listener.getLogger().println("Stopping Old Application '" + artifact + "'...");
            service.stopArtifact(artifact);
        }
    }

    private void uninstallArtifact(Artifact artifact, BuildListener listener, LibertyDeploymentService service) throws Exception {
        if (service.isArtifactInstalled(artifact)) {
            listener.getLogger().println("Uninstalling Old Application '" + artifact.getAppName() + "'...");
            service.uninstallArtifact(artifact);
        }
    }

    private void deployArtifact(Artifact artifact, BuildListener listener, LibertyDeploymentService service) throws Exception {
        listener.getLogger().println("Deploying '" + artifact.getAppName() + "' to IBM WebSphere Liberty Profile");
        service.installArtifact(artifact);
    }

    private void startArtifact(Artifact artifact, BuildListener listener, LibertyDeploymentService service) throws Exception {
        listener.getLogger().println("Starting Application '" + artifact.getAppName() + "'...");
        service.startArtifact(artifact);
    }

    private FilePath[] gatherArtifactPaths(AbstractBuild build, BuildListener listener) throws Exception {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            listener.getLogger().println("Failed to gather artifact paths: Build workspace is null");
            throw new IllegalStateException("Failed to gather artifact paths: Build workspace is null");
        }
        FilePath workspaceParent = workspace.getParent();
        if (workspaceParent == null) {
            listener.getLogger().println("Failed to gather artifact paths: Build workspace's parent path is null");
            throw new IllegalStateException("Failed to gather artifact paths: Build workspace's parent path is null");
        }
        FilePath[] paths = workspaceParent.list(this.getArtifacts());
        if (paths.length == 0) {
            listener.getLogger().println("No deployable artifacts found in path: " + workspaceParent + File.separator + this.getArtifacts());
            throw new Exception("No deployable artifacts found!");
        }
        listener.getLogger().println("The following artifacts will be deployed in this order...");
        listener.getLogger().println("-------------------------------------------");
        for (FilePath path : paths) {
            listener.getLogger().println(path.getName());
        }
        listener.getLogger().println("-------------------------------------------");
        return paths;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter(value="ipAddress") String ipAddress, @QueryParameter(value="port") String port, @QueryParameter(value="username") String username, @QueryParameter(value="consolePassword") String password, @QueryParameter(value="clientTrustFile") String clientTrustFile, @QueryParameter(value="clientTrustPassword") String clientTrustPassword) throws IOException, ServletException {
            LibertyDeploymentService service = new LibertyDeploymentService();
            System.out.println("ClassLoader: " + ((Object)((Object)this)).getClass().getClassLoader());
            System.out.println("Parent ClassLoader: " + ((Object)((Object)this)).getClass().getClassLoader().getParent());
            System.out.println("System ClassLoader: " + ClassLoader.getSystemClassLoader());
            if (!service.isAvailable()) {
                String destination = System.getProperty("user.home") + File.separator + ".jenkins" + File.separator + "plugins" + File.separator + "websphere-deployer" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator;
                return FormValidation.warning((String)("Cannot find the required IBM WebSphere Liberty jar files in '" + destination + "'. Please copy them from IBM WebSphere Liberty (see plugin documentation)"));
            }
            try {
                service.setHost(ipAddress);
                service.setPort(port);
                service.setUsername(username);
                service.setPassword(password);
                service.setTrustStoreLocation(new File(clientTrustFile));
                service.setTrustStorePassword(clientTrustPassword);
                service.connect();
                FormValidation destination = FormValidation.ok((String)"Connection Successful!");
                return destination;
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream p = new PrintStream((OutputStream)out, true, "UTF-8");
                e.printStackTrace(p);
                FormValidation formValidation = FormValidation.error((String)("Connection failed: " + new String(out.toByteArray(), "UTF-8")));
                return formValidation;
            }
            finally {
                service.disconnect();
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy To IBM WebSphere Liberty Profile";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

