/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.websphere.services.deployment;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import hudson.model.BuildListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.spi.Target;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.websphere.services.deployment.AbstractDeploymentService;
import org.jenkinsci.plugins.websphere.services.deployment.Artifact;
import org.jenkinsci.plugins.websphere.services.deployment.DeploymentNotificationListener;
import org.jenkinsci.plugins.websphere.services.deployment.DeploymentServiceException;
import org.jenkinsci.plugins.websphere.services.deployment.SSLUtilities;
import org.jenkinsci.plugins.websphere.services.deployment.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebSphereDeploymentService
extends AbstractDeploymentService {
    public static final String CONNECTOR_TYPE_SOAP = "SOAP";
    private static final String className = WebSphereDeploymentService.class.getName();
    private static Logger log = Logger.getLogger(className);
    private AdminClient client;
    private String connectorType;
    private boolean verbose;
    private boolean trustAll;
    private BuildListener buildListener;
    private Properties storedProperties;

    public WebSphereDeploymentService() {
        System.setProperty("com.ibm.websphere.thinclient", "true");
    }

    public List<Server> listServers() {
        try {
            if (!this.isConnected()) {
                throw new DeploymentServiceException("Cannot list servers, please connect to WebSphere first");
            }
            ObjectName targetQuery = new ObjectName("WebSphere:*,type=J2EEAppDeployment");
            Set appDeployments = this.client.queryNames(targetQuery, null);
            ArrayList<Server> servers = new ArrayList<Server>();
            for (ObjectName appDeployment : appDeployments) {
                Target[] targets;
                for (Target target : targets = (Target[])this.client.invoke(appDeployment, "getTargets", new Object[]{null, null}, new String[]{Hashtable.class.getName(), String.class.getName()})) {
                    if (!target.getName().contains("J2EEServer")) continue;
                    Server server = new Server();
                    server.setObjectName(target.getName());
                    server.setTarget(this.getFormattedTarget(target.getName()));
                    servers.add(server);
                }
                Collections.sort(servers);
                int i = 0;
                for (Server server : servers) {
                    server.setIndex(i++);
                }
            }
            return servers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEAR(Artifact artifact, File destination, String earLevel) {
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            int len;
            out = new ZipOutputStream(new FileOutputStream(destination));
            in = new FileInputStream(artifact.getSourcePath());
            out.putNextEntry(new ZipEntry(artifact.getSourcePath().getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            out.putNextEntry(new ZipEntry("META-INF/"));
            out.closeEntry();
            out.putNextEntry(new ZipEntry("META-INF/application.xml"));
            out.write(this.getApplicationXML(artifact, earLevel).getBytes(Charset.forName("UTF-8")));
            out.closeEntry();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContextRoot(Artifact artifact) {
        ZipFile zipFile = null;
        try {
            if (artifact.getContext() != null) {
                String string = artifact.getContext();
                return string;
            }
            zipFile = new ZipFile(artifact.getSourcePath());
            ZipEntry webExt = zipFile.getEntry("WEB-INF/ibm-web-ext.xml");
            if (webExt != null) {
                InputStream webExtContent = zipFile.getInputStream(webExt);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(webExtContent);
                Element contextRoot = (Element)doc.getElementsByTagName("context-root").item(0);
                String uri = contextRoot.getAttribute("uri");
                String string = uri = uri.startsWith("/") ? uri : "/" + uri;
                return string;
            }
            String string = this.getContextRootFromWarName(artifact);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = this.getContextRootFromWarName(artifact);
            return string;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getContextRootFromWarName(Artifact artifact) {
        String warName = artifact.getSourcePath().getName();
        return warName.substring(0, warName.lastIndexOf("."));
    }

    private String getApplicationXML(Artifact artifact, String earLevel) {
        String contextRoot = this.getContextRoot(artifact).trim();
        String warName = artifact.getSourcePath().getName();
        String displayName = StringUtils.trimToNull((String)artifact.getAppName());
        if (displayName == null) {
            displayName = warName;
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + this.getSchemaVersion(earLevel) + ">\n" + "  <description>" + warName + " was deployed using WebSphere Deployer Plugin</description>\n" + "  <display-name>" + displayName + "</display-name>\n" + "  <module>\n" + "    <web>\n" + "      <web-uri>" + warName + "</web-uri>\n" + "      <context-root>" + contextRoot + "</context-root>\n" + "    </web>\n" + "  </module>\n" + "</application>";
    }

    private String getSchemaVersion(String earLevel) {
        if (earLevel.equals("7") || earLevel.equals("8")) {
            return "xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/application_" + earLevel + ".xsd\" version=\"" + earLevel + "\"";
        }
        return "xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_" + earLevel + ".xsd\" version=\"" + earLevel + "\"";
    }

    public String getAppName(String path) {
        return this.getAppName(new File(path));
    }

    public String getAppName(File file) {
        try {
            Hashtable<String, Cloneable> preferences = new Hashtable<String, Cloneable>();
            preferences.put("app.client.locale", Locale.getDefault());
            preferences.put("usedefaultbindings", new Properties());
            AppDeploymentController controller = AppDeploymentController.readArchive((String)file.getAbsolutePath(), preferences);
            AppDeploymentTask task = controller.getFirstTask();
            while (task != null) {
                String[][] data = task.getTaskData();
                task.setTaskData(data);
                task = controller.getNextTask();
            }
            controller.saveAndClose();
            Hashtable config = controller.getAppDeploymentSavedResults();
            return (String)config.get("appname");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException(e.getMessage(), e);
        }
    }

    private Hashtable<String, Object> buildDeploymentPreferences(Artifact artifact) throws Exception {
        if (artifact.getPreferences().size() > 0) {
            return artifact.getPreferences();
        }
        Hashtable<String, Cloneable> defaultBindingPreferences = new Hashtable<String, Cloneable>();
        Properties defaultBinding = new Properties();
        defaultBindingPreferences.put("app.client.locale", Locale.getDefault());
        if (StringUtils.trimToNull((String)artifact.getVirtualHost()) != null) {
            defaultBinding.put("defaultbinding.virtual.host", artifact.getVirtualHost());
        }
        defaultBindingPreferences.put("usedefaultbindings", defaultBinding);
        AppDeploymentController controller = AppDeploymentController.readArchive((String)artifact.getSourcePath().getAbsolutePath(), defaultBindingPreferences);
        Object[] validationResult = controller.validate();
        if (validationResult != null && validationResult.length > 0) {
            throw new DeploymentServiceException("Unable to complete all task data for deployment preparation. Reason: " + Arrays.toString(validationResult));
        }
        controller.saveAndClose();
        Hashtable options = controller.getAppOptions();
        options.put("app.client.locale", Locale.getDefault());
        options.put("archive.upload", Boolean.TRUE);
        options.put("preCompileJSPs", artifact.isPrecompile());
        options.put("distributeApp", artifact.isDistribute());
        options.put("jspReloadEnabled", artifact.isJspReloading());
        options.put("reloadEnabled", artifact.isReloading());
        if (StringUtils.trimToNull((String)artifact.getEdition()) != null) {
            options.put("edition", artifact.getEdition());
            options.put("edition.desc", String.valueOf("Edition Timestamp: " + System.currentTimeMillis()));
        }
        if (StringUtils.trimToNull((String)artifact.getSharedLibName()) != null) {
            options.put("sharedLibName", artifact.getSharedLibName());
            options.put("mapSharedLib", artifact.getSharedLibName());
        }
        if (!artifact.isJspReloading()) {
            options.put("jspReloadInterval", 0);
        } else {
            options.put("jspReloadInterval", 15);
        }
        if (!artifact.isReloading()) {
            options.put("reloadInterval", 0);
        } else {
            options.put("reloadInterval", 15);
        }
        if (StringUtils.trimToNull((String)artifact.getAppName()) != null) {
            options.put("appname", artifact.getAppName());
        }
        if (StringUtils.trimToNull((String)artifact.getInstallPath()) != null) {
            options.put("installed.ear.destination", artifact.getInstallPath());
        }
        if (StringUtils.trimToNull((String)artifact.getClassLoaderOrder()) != null) {
            options.put("classLoadingMode", artifact.getClassLoaderOrder());
        }
        if (StringUtils.trimToNull((String)artifact.getClassLoaderPolicy()) != null) {
            options.put("classLoaderPolicy", artifact.getClassLoaderPolicy());
        }
        if (StringUtils.trimToNull((String)artifact.getContext()) != null) {
            options.put("contextroot", artifact.getContext());
            options.put("web.contextroot", artifact.getContext());
        }
        Hashtable<String, String> module2server = new Hashtable<String, String>();
        module2server.put("*", this.getFormattedTargets(artifact.getTargets()));
        options.put("moduleToServer", module2server);
        artifact.setPreferences(options);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installArtifact(Artifact artifact) {
        if (!this.isConnected()) {
            throw new DeploymentServiceException("Cannot install artifact, no connection to IBM WebSphere Application Server exists");
        }
        try {
            NotificationFilterSupport filterSupport = this.createFilterSupport();
            DeploymentNotificationListener notifyListener = new DeploymentNotificationListener(this.getAdminClient(), filterSupport, "Install " + artifact.getAppName(), "InstallApplication", this.buildListener, this.verbose);
            AppManagement appManagementProxy = AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient());
            appManagementProxy.installApplication(artifact.getSourcePath().getAbsolutePath(), artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
            while (!notifyListener.hasEventTriggered()) {
                DeploymentNotificationListener deploymentNotificationListener = notifyListener;
                synchronized (deploymentNotificationListener) {
                    if (!notifyListener.hasEventTriggered()) {
                        notifyListener.wait();
                    }
                }
            }
            if (!notifyListener.isSuccessful()) {
                throw new DeploymentServiceException("Application not successfully deployed: " + notifyListener.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Failed to install artifact: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArtifact(Artifact artifact) {
        if (!this.isConnected()) {
            throw new DeploymentServiceException("Cannot update artifact, no connection to IBM WebSphere Application Server exists");
        }
        try {
            NotificationFilterSupport filterSupport = this.createFilterSupport();
            DeploymentNotificationListener notifyListener = new DeploymentNotificationListener(this.getAdminClient(), filterSupport, "Update " + artifact.getAppName(), "InstallApplication", this.buildListener, this.verbose);
            AppManagement appManagementProxy = AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient());
            appManagementProxy.redeployApplication(artifact.getSourcePath().getAbsolutePath(), artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
            while (!notifyListener.hasEventTriggered()) {
                DeploymentNotificationListener deploymentNotificationListener = notifyListener;
                synchronized (deploymentNotificationListener) {
                    if (!notifyListener.hasEventTriggered()) {
                        notifyListener.wait();
                    }
                }
            }
            if (!notifyListener.isSuccessful()) {
                throw new DeploymentServiceException("Application not successfully updated: " + notifyListener.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Failed to update artifact: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallArtifact(Artifact artifact) throws Exception {
        try {
            NotificationFilterSupport filterSupport = this.createFilterSupport();
            DeploymentNotificationListener notifyListener = new DeploymentNotificationListener(this.getAdminClient(), filterSupport, "Uninstall " + artifact.getAppName(), "UninstallApplication", this.buildListener, this.verbose);
            AppManagement appManagementProxy = AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient());
            appManagementProxy.uninstallApplication(artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
            while (!notifyListener.hasEventTriggered()) {
                DeploymentNotificationListener deploymentNotificationListener = notifyListener;
                synchronized (deploymentNotificationListener) {
                    if (!notifyListener.hasEventTriggered()) {
                        notifyListener.wait();
                    }
                }
            }
            if (!notifyListener.isSuccessful()) {
                throw new DeploymentServiceException("Application not successfully undeployed: " + notifyListener.getMessage());
            }
        }
        catch (Exception e) {
            throw new DeploymentServiceException("Could not undeploy application", e);
        }
    }

    @Override
    public void startArtifact(Artifact artifact) throws Exception {
        this.startArtifact(artifact, 5);
    }

    public void startArtifact(Artifact artifact, int deploymentTimeout) throws Exception {
        block4: {
            try {
                AppManagement appManagementProxy = AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient());
                if (this.waitForApplicationDistribution(appManagementProxy, artifact, deploymentTimeout * 60)) {
                    String targetsStarted = appManagementProxy.startApplication(artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
                    log.info("Application was started on the following targets: " + targetsStarted);
                    if (targetsStarted == null) {
                        throw new DeploymentServiceException("Application did not start successfully. WAS JVM logs should contain more detailed information.");
                    }
                    break block4;
                }
                throw new DeploymentServiceException("Distribution of application did not succeed on all nodes.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DeploymentServiceException("Could not start artifact '" + artifact.getAppName() + "': " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForApplicationDistribution(AppManagement appManagementProxy, Artifact artifact, int secondsToWait) throws Exception {
        int totalSeconds = 0;
        NotificationFilterSupport filterSupport = this.createFilterSupport();
        DeploymentNotificationListener distributionListener = null;
        while (this.checkDistributionStatus(distributionListener) != "true" && totalSeconds < secondsToWait) {
            Thread.sleep(1000L);
            ++totalSeconds;
            DeploymentNotificationListener deploymentNotificationListener = distributionListener = new DeploymentNotificationListener(this.getAdminClient(), filterSupport, null, "AppDistributionNode", this.buildListener, this.verbose);
            synchronized (deploymentNotificationListener) {
                if (!distributionListener.hasEventTriggered()) {
                    appManagementProxy.getDistributionStatus(artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
                    distributionListener.wait();
                }
            }
        }
        return totalSeconds <= secondsToWait;
    }

    @Override
    public void stopArtifact(Artifact artifact) throws Exception {
        try {
            AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient()).stopApplication(artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Could not stop artifact '" + artifact.getAppName() + "': " + e.getMessage());
        }
    }

    @Override
    public boolean isArtifactInstalled(Artifact artifact) {
        try {
            AppManagement appManagement = AppManagementProxy.getJMXProxyForClient((AdminClient)this.getAdminClient());
            return appManagement.checkIfAppExists(artifact.getAppName(), this.buildDeploymentPreferences(artifact), null);
        }
        catch (AdminException e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Could not determine if artifact '" + artifact.getAppName() + "' is installed: AdminException: " + e.getMessage());
        }
        catch (ConnectorException e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Could not determine if artifact '" + artifact.getAppName() + "' is installed: ConnectorException: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException("Could not determine if artifact '" + artifact.getAppName() + "' is installed: General Exception: " + e.getMessage());
        }
    }

    private NotificationFilterSupport createFilterSupport() {
        NotificationFilterSupport filterSupport = new NotificationFilterSupport();
        filterSupport.enableType("websphere.admin.appmgmt");
        return filterSupport;
    }

    public boolean isConnected() {
        try {
            return this.client != null && this.client.isAlive() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void connect() throws Exception {
        this.storedProperties = (Properties)System.getProperties().clone();
        if (this.isConnected()) {
            log.warning("Already connected to WebSphere Application Server");
        }
        Properties config = new Properties();
        config.put("host", this.getHost());
        config.put("port", this.getPort());
        if (StringUtils.trimToNull((String)this.getUsername()) != null) {
            this.injectSecurityConfiguration(config);
        }
        config.put("type", this.getConnectorType());
        this.client = AdminClientFactory.createAdminClient((Properties)config);
        if (this.client == null) {
            throw new DeploymentServiceException("Unable to connect to IBM WebSphere Application Server @ " + this.getHost() + ":" + this.getPort());
        }
    }

    @Override
    public void disconnect() {
        if (this.storedProperties != null) {
            System.setProperties(this.storedProperties);
            this.storedProperties = null;
        }
        if (this.client != null) {
            this.client.getConnectorProperties().clear();
            this.client = null;
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("com.ibm.websphere.management.AdminClientFactory", false, this.getClass().getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private AdminClient getAdminClient() throws ConnectorException {
        if (this.client == null) {
            throw new DeploymentServiceException("No connection to WebSphere exists");
        }
        return this.client;
    }

    private void injectSecurityConfiguration(Properties config) {
        SSLSocketFactory.getDefault();
        config.put("cacheDisabled", "true");
        config.put("securityEnabled", "true");
        config.put("username", this.getUsername());
        config.put("password", this.getPassword());
        if (this.trustAll) {
            SSLUtilities.trustAllHostnames();
            SSLUtilities.trustAllHttpsCertificates();
        } else {
            if (this.getTrustStoreLocation() != null && this.getTrustStoreLocation().getAbsolutePath().endsWith(".jks")) {
                config.put("com.ibm.ssl.trustStore", this.getTrustStoreLocation().getAbsolutePath());
                config.put("javax.net.ssl.trustStore", this.getTrustStoreLocation().getAbsolutePath());
            }
            if (this.getKeyStoreLocation() != null && this.getKeyStoreLocation().getAbsolutePath().endsWith(".jks")) {
                config.put("com.ibm.ssl.keyStore", this.getKeyStoreLocation().getAbsolutePath());
                config.put("javax.net.ssl.keyStore", this.getKeyStoreLocation().getAbsolutePath());
            }
            if (this.getTrustStorePassword() != null && !this.getTrustStorePassword().equals("")) {
                config.put("com.ibm.ssl.trustStorePassword", this.getTrustStorePassword());
                config.put("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
            }
            if (this.getKeyStorePassword() != null && !this.getKeyStorePassword().equals("")) {
                config.put("com.ibm.ssl.keyStorePassword", this.getKeyStorePassword());
                config.put("javax.net.ssl.keyStorePassword", this.getKeyStorePassword());
            }
        }
    }

    private String getFormattedTargets(String targets) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(targets.trim(), "\r\n");
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return StringUtils.join(result, (String)"+");
    }

    private String getFormattedTarget(String target) {
        target = target.replace("WebSphere:", "").replace(",j2eeType=J2EEServer", "");
        Object[] elements = target.split(",");
        ArrayUtils.reverse((Object[])elements);
        return "WebSphere:" + StringUtils.join((Object[])elements, (String)",");
    }

    public void setConnectorType(String type) {
        this.connectorType = type;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBuildListener(BuildListener listener) {
        this.buildListener = listener;
    }

    private String checkDistributionStatus(DeploymentNotificationListener listener) throws MalformedObjectNameException {
        String compositeServers;
        String distributionState = "unknown";
        if (listener != null && (compositeServers = listener.getNotificationProps().getProperty("AppDistributionAll")) != null) {
            if (this.verbose) {
                this.buildListener.getLogger().println("Server Composite: " + compositeServers);
            }
            String[] servers = compositeServers.split("\\+");
            int countTrue = 0;
            int countFalse = 0;
            int countUnknown = 0;
            for (String server : servers) {
                ObjectName serverObject = new ObjectName(server);
                distributionState = serverObject.getKeyProperty("distribution");
                if (this.verbose) {
                    this.buildListener.getLogger().println("Distributed to " + server + ": " + distributionState);
                }
                if (distributionState.equals("true")) {
                    ++countTrue;
                }
                if (distributionState.equals("false")) {
                    ++countFalse;
                }
                if (!distributionState.equals("unknown")) continue;
                ++countUnknown;
            }
            if (countUnknown > 0) {
                distributionState = "unknown";
            } else if (countFalse > 0) {
                distributionState = "false";
            } else if (countTrue > 0) {
                distributionState = "true";
            } else {
                throw new DeploymentServiceException("Reported distribution status is invalid.");
            }
        }
        return distributionState;
    }

    public void fullyResynchronizeNodes() {
        try {
            ObjectName serverObject = new ObjectName("WebSphere:type=NodeSync,*");
            Set nodes = this.client.queryNames(serverObject, null);
            for (ObjectName node : nodes) {
                this.client.invoke(node, "sync", new Object[0], new String[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentServiceException(e.getMessage(), e);
        }
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }
}

