/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;
import org.jenkinsci.plugins.deploy.weblogic.util.VarUtils;
import org.jenkinsci.remoting.RoleChecker;

public class FreeStyleJobArtifactSelectorImpl
implements ArtifactSelector {
    @Override
    public FilePath selectArtifactRecorded(AbstractBuild<?, ?> build, BuildListener listener, String filteredResource, String baseDirectory) throws IOException, InterruptedException {
        FilePath selectedArtifact = null;
        listener.getLogger().println("[WeblogicDeploymentPlugin] - Retrieving artifacts recorded [filtered resources on " + filteredResource + "]...");
        ArrayList<FilePath> artifactsRecorded = new ArrayList<FilePath>();
        List filesToCheck = Lists.newArrayList();
        FilePath baseDir = null;
        if (StringUtils.isBlank((String)baseDirectory)) {
            baseDir = build.getWorkspace();
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No the base directory set. Looking up for workspace directory located on '" + baseDir + "'...");
        } else {
            EnvVars vars = VarUtils.getEnvVars(build, listener);
            String resolvedBaseDirectory = vars.expand(baseDirectory);
            baseDir = new FilePath(build.getBuiltOn().getChannel(), resolvedBaseDirectory);
            if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.toVirtualFile().canRead())) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following base directory '" + resolvedBaseDirectory + "' is invalid on node '" + build.getBuiltOnStr() + "' (doesn't exist or is not a directory or has insufficient privilege). Please check the job configuration");
                throw new RuntimeException("The base directory '" + resolvedBaseDirectory + "' is invalid on node '" + build.getBuiltOnStr() + "' (doesn't exist or is not a directory or has insufficient privilege)");
            }
        }
        filesToCheck = (List)baseDir.act((FilePath.FileCallable)new RecursiveWorkspaceLookup());
        listener.getLogger().println("[WeblogicDeploymentPlugin] - " + filesToCheck.size() + " files found under directory " + baseDir.getRemote());
        for (FilePath file : filesToCheck) {
            if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource recorded " + file + " is eligible.");
                artifactsRecorded.add(file);
                continue;
            }
            listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource ['" + file.getRemote() + "'] doesn't match " + filteredResource);
        }
        if (artifactsRecorded.size() < 1) {
            throw new RuntimeException("No artifact to deploy [" + filteredResource + "] found.");
        }
        if (artifactsRecorded.size() > 1) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - More than 1 artifact found : The first one " + artifactsRecorded.get(0) + " will be deployed!!!");
        }
        if ((selectedArtifact = (FilePath)artifactsRecorded.get(0)) == null) {
            throw new RuntimeException("No artifact to deploy found.");
        }
        return selectedArtifact;
    }

    @Override
    public String getName() {
        return "FreeStyleProject";
    }

    private static class RecursiveWorkspaceLookup
    implements FilePath.FileCallable<List<FilePath>> {
        private static final long serialVersionUID = 1L;

        private RecursiveWorkspaceLookup() {
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }

        public List<FilePath> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            ArrayList result = Lists.newArrayList();
            Collection files = FileUtils.listFiles((File)f, null, (boolean)true);
            for (File file : files) {
                result.add(new FilePath(file));
            }
            return result;
        }
    }
}

