/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.task;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.JDK;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;
import org.jenkinsci.plugins.deploy.weblogic.FreeStyleJobArtifactSelectorImpl;
import org.jenkinsci.plugins.deploy.weblogic.MavenJobArtifactSelectorImpl;
import org.jenkinsci.plugins.deploy.weblogic.WeblogicDeploymentPlugin;
import org.jenkinsci.plugins.deploy.weblogic.WeblogicDeploymentPluginLog;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTask;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTaskResult;
import org.jenkinsci.plugins.deploy.weblogic.data.TransfertConfiguration;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicDeploymentStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicPreRequisteStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WeblogicEnvironment;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicCommand;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployer;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployerParameters;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployerTokenResolver;
import org.jenkinsci.plugins.deploy.weblogic.exception.DeploymentTaskException;
import org.jenkinsci.plugins.deploy.weblogic.exception.RequiredJDKNotFoundException;
import org.jenkinsci.plugins.deploy.weblogic.jdk.JdkToolService;
import org.jenkinsci.plugins.deploy.weblogic.task.DeploymentTaskService;
import org.jenkinsci.plugins.deploy.weblogic.util.FTPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(optional=false)
public class DeploymentTaskServiceImpl
implements DeploymentTaskService {
    @Inject
    private WeblogicDeploymentPlugin.WeblogicDeploymentPluginDescriptor descriptor;
    @Inject
    private WebLogicDeployerTokenResolver tokenResolver;

    @Override
    public DeploymentTaskResult perform(DeploymentTask task, String globalJdk, AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) throws DeploymentTaskException {
        FileOutputStream deploymentLogOut;
        JDK selectedJdk = null;
        try {
            selectedJdk = task.getJdk() != null && task.getJdk().getExists() ? task.getJdk() : JdkToolService.getJDKByName(globalJdk);
            if (selectedJdk == null || !selectedJdk.getExists()) {
                String execu = selectedJdk != null ? selectedJdk.getHome() : "";
                throw new RequiredJDKNotFoundException("Unable to find PATH to the JDK's executable [" + execu + "]");
            }
            JdkToolService.checkJdkVersion(selectedJdk, listener.getLogger());
        }
        catch (RequiredJDKNotFoundException rjnfe) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - No JDK found. The plugin execution is disabled.");
            throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.ABORTED, task, null));
        }
        listener.getLogger().println("[WeblogicDeploymentPlugin] - The JDK " + selectedJdk.getHome() + " will be used.");
        try {
            deploymentLogOut = new FileOutputStream(WeblogicDeploymentPluginLog.getDeploymentLogFile(build, task.getId()));
        }
        catch (FileNotFoundException fnfe) {
            listener.error("[WeblogicDeploymentPlugin] - Failed to find deployment log file : " + fnfe.getMessage());
            throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.ABORTED, task, null));
        }
        FilePath archivedArtifact = null;
        String artifactName = null;
        String fullArtifactFinalName = null;
        try {
            Class<?> jobType = build.getProject().getClass();
            ArtifactSelector artifactSelector = null;
            if (AbstractMavenProject.class.isAssignableFrom(jobType)) {
                artifactSelector = new MavenJobArtifactSelectorImpl();
            } else if (FreeStyleProject.class.isAssignableFrom(jobType)) {
                artifactSelector = new FreeStyleJobArtifactSelectorImpl();
            }
            if (artifactSelector == null) {
                IOUtils.closeQuietly((OutputStream)deploymentLogOut);
                throw new RuntimeException("No artifact selector has been found for the jop type [" + jobType + "]");
            }
            listener.getLogger().println("[WeblogicDeploymentPlugin] - ArtifactSelector used : " + artifactSelector);
            FilePath selectedArtifact = artifactSelector.selectArtifactRecorded(build, listener, task.getBuiltResourceRegexToDeploy(), task.getBaseResourcesGeneratedDirectory());
            artifactName = StringUtils.substringBeforeLast((String)selectedArtifact.getBaseName(), (String)".");
            archivedArtifact = selectedArtifact;
            fullArtifactFinalName = selectedArtifact.getName();
        }
        catch (Throwable e) {
            listener.error("[WeblogicDeploymentPlugin] - Failed to get artifact from archive directory : " + e.getMessage());
            IOUtils.closeQuietly((OutputStream)deploymentLogOut);
            throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.ABORTED, task, null));
        }
        WeblogicEnvironment weblogicEnvironmentTargeted = null;
        try {
            Pattern pattern = Pattern.compile(this.getDescriptor().getExcludedArtifactNamePattern());
            Matcher matcher = pattern.matcher(artifactName);
            if (matcher.matches()) {
                listener.error("[WeblogicDeploymentPlugin] - The artifact Name " + artifactName + " is excluded from deployment (see exclusion list).");
                throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.ABORTED, task, fullArtifactFinalName));
            }
            weblogicEnvironmentTargeted = this.getWeblogicEnvironmentTargeted(task.getWeblogicEnvironmentTargetedName(), listener);
            if (weblogicEnvironmentTargeted == null) {
                listener.error("[WeblogicDeploymentPlugin] - WebLogic environment Name " + task.getWeblogicEnvironmentTargetedName() + " not found in the list. Please check the configuration file.");
                throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.ABORTED, task, fullArtifactFinalName));
            }
            listener.getLogger().println("[WeblogicDeploymentPlugin] - Deploying the artifact on the following target : (name=" + task.getWeblogicEnvironmentTargetedName() + ") (host=" + weblogicEnvironmentTargeted.getHost() + ") (port=" + weblogicEnvironmentTargeted.getPort() + ")");
            if (StringUtils.isBlank((String)task.getCommandLine())) {
                this.undeploy(task, build, listener, launcher, weblogicEnvironmentTargeted, selectedJdk, artifactName, deploymentLogOut);
                this.deploy(task, build, listener, launcher, weblogicEnvironmentTargeted, selectedJdk, artifactName, deploymentLogOut, archivedArtifact, fullArtifactFinalName);
            } else {
                this.customize(task, build, listener, launcher, weblogicEnvironmentTargeted, selectedJdk, artifactName, deploymentLogOut, archivedArtifact, fullArtifactFinalName);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(listener.getLogger());
            listener.error("[WeblogicDeploymentPlugin] - Failed to deploy.");
            throw new DeploymentTaskException(new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.FAILED, task, fullArtifactFinalName));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)deploymentLogOut);
        }
        return new DeploymentTaskResult(WebLogicPreRequisteStatus.OK, WebLogicDeploymentStatus.SUCCEEDED, task, fullArtifactFinalName);
    }

    private void deploy(DeploymentTask task, AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, WeblogicEnvironment weblogicEnvironmentTargeted, JDK selectedJdk, String artifactName, OutputStream deploymentLogOut, FilePath archivedArtifact, String fullArtifactFinalName) throws IOException, InterruptedException {
        String sourceFile = null;
        String remoteFilePath = null;
        if (task.getIsLibrary()) {
            String ftpHost = StringUtils.isBlank((String)weblogicEnvironmentTargeted.getFtpHost()) ? weblogicEnvironmentTargeted.getHost() : weblogicEnvironmentTargeted.getFtpHost();
            remoteFilePath = weblogicEnvironmentTargeted.getRemoteDir() + "/" + fullArtifactFinalName;
            String localFilePath = archivedArtifact.getRemote();
            listener.getLogger().println("[WeblogicDeploymentPlugin] - TRANSFERING LIBRARY : (local=" + fullArtifactFinalName + ") (remote=" + remoteFilePath + ") to (ftp=" + ftpHost + "@" + weblogicEnvironmentTargeted.getFtpUser() + ") ...");
            FTPUtils.transfertFile(new TransfertConfiguration(ftpHost, weblogicEnvironmentTargeted.getFtpUser(), weblogicEnvironmentTargeted.getFtpPassowrd(), localFilePath, remoteFilePath), listener.getLogger());
            listener.getLogger().println("[WeblogicDeploymentPlugin] - LIBRARY TRANSFERED SUCCESSFULLY.");
        }
        sourceFile = task.getIsLibrary() ? remoteFilePath : archivedArtifact.getRemote();
        WebLogicDeployerParameters deployWebLogicDeployerParameters = new WebLogicDeployerParameters(build, launcher, listener, selectedJdk, task.getDeploymentName(), task.getIsLibrary(), task.getDeploymentTargets(), weblogicEnvironmentTargeted, artifactName, sourceFile, WebLogicCommand.DEPLOY, false, this.getDescriptor().getJavaOpts(), this.getDescriptor().getExtraClasspath(), task.getStageMode());
        Object[] deployCommand = WebLogicDeployer.getWebLogicCommandLine(deployWebLogicDeployerParameters);
        listener.getLogger().println("[WeblogicDeploymentPlugin] - DEPLOYING ARTIFACT...");
        deploymentLogOut.write("------------------------------------  ARTIFACT DEPLOYMENT ------------------------------------------------\r\n".getBytes());
        Proc deploymentProc = launcher.launch().cmds((String[])deployCommand).stdout(deploymentLogOut).start();
        int exitStatus = deploymentProc.join();
        if (exitStatus != 0) {
            listener.error("[WeblogicDeploymentPlugin] - Command " + StringUtils.join((Object[])deployCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
            throw new RuntimeException("Command " + StringUtils.join((Object[])deployCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
        }
        listener.getLogger().println("[WeblogicDeploymentPlugin] - ARTIFACT DEPLOYED SUCCESSFULLY.");
    }

    private void undeploy(DeploymentTask task, AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, WeblogicEnvironment weblogicEnvironmentTargeted, JDK selectedJdk, String artifactName, OutputStream deploymentLogOut) throws IOException, InterruptedException {
        WebLogicDeployerParameters undeployWebLogicDeployerParameters = new WebLogicDeployerParameters(build, launcher, listener, selectedJdk, task.getDeploymentName(), task.getIsLibrary(), task.getDeploymentTargets(), weblogicEnvironmentTargeted, artifactName, null, WebLogicCommand.UNDEPLOY, true, this.getDescriptor().getJavaOpts(), this.getDescriptor().getExtraClasspath(), task.getStageMode());
        String[] undeployCommand = WebLogicDeployer.getWebLogicCommandLine(undeployWebLogicDeployerParameters);
        deploymentLogOut.write("------------------------------------  ARTIFACT UNDEPLOYMENT ------------------------------------------------\r\n".getBytes());
        listener.getLogger().println("[WeblogicDeploymentPlugin] - UNDEPLOYING ARTIFACT...");
        Proc undeploymentProc = launcher.launch().cmds(undeployCommand).stdout(deploymentLogOut).start();
        undeploymentProc.join();
        listener.getLogger().println("[WeblogicDeploymentPlugin] - ARTIFACT UNDEPLOYED SUCCESSFULLY.");
    }

    private void customize(DeploymentTask task, AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, WeblogicEnvironment weblogicEnvironmentTargeted, JDK selectedJdk, String artifactName, OutputStream deploymentLogOut, FilePath archivedArtifact, String fullArtifactFinalName) throws IOException, InterruptedException {
        String[] commandLines;
        String sourceFile = null;
        String remoteFilePath = null;
        if (task.getIsLibrary()) {
            String ftpHost = StringUtils.isBlank((String)weblogicEnvironmentTargeted.getFtpHost()) ? weblogicEnvironmentTargeted.getHost() : weblogicEnvironmentTargeted.getFtpHost();
            remoteFilePath = weblogicEnvironmentTargeted.getRemoteDir() + "/" + fullArtifactFinalName;
            String localFilePath = archivedArtifact.getRemote();
            listener.getLogger().println("[WeblogicDeploymentPlugin] - TRANSFERING LIBRARY : (local=" + fullArtifactFinalName + ") (remote=" + remoteFilePath + ") to (ftp=" + ftpHost + "@" + weblogicEnvironmentTargeted.getFtpUser() + ") ...");
            FTPUtils.transfertFile(new TransfertConfiguration(ftpHost, weblogicEnvironmentTargeted.getFtpUser(), weblogicEnvironmentTargeted.getFtpPassowrd(), localFilePath, remoteFilePath), listener.getLogger());
            listener.getLogger().println("[WeblogicDeploymentPlugin] - LIBRARY TRANSFERED SUCCESSFULLY.");
        }
        sourceFile = task.getIsLibrary() ? remoteFilePath : archivedArtifact.getRemote();
        WebLogicDeployerParameters executionDeployerParameters = new WebLogicDeployerParameters(build, launcher, listener, selectedJdk, task.getDeploymentName(), task.getIsLibrary(), task.getDeploymentTargets(), weblogicEnvironmentTargeted, artifactName, sourceFile, null, true, this.getDescriptor().getJavaOpts(), this.getDescriptor().getExtraClasspath(), task.getStageMode());
        for (String command : commandLines = StringUtils.split((String)task.getCommandLine(), (String)";")) {
            if (StringUtils.isBlank((String)command)) continue;
            String newCommand = this.replaceTokens(StringUtils.trim((String)command), executionDeployerParameters);
            Object[] executionCommand = WebLogicDeployer.getWebLogicCommandLine(executionDeployerParameters, newCommand);
            deploymentLogOut.write("------------------------------------  TASK EXECUTION ------------------------------------------------\r\n".getBytes());
            listener.getLogger().println("[WeblogicDeploymentPlugin] - EXECUTING TASK ...");
            Proc executionProc = launcher.launch().cmds((String[])executionCommand).stdout(deploymentLogOut).start();
            int exitStatus = executionProc.join();
            if (exitStatus == 0) continue;
            listener.error("[WeblogicDeploymentPlugin] - Command " + StringUtils.join((Object[])executionCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
            throw new RuntimeException("Command " + StringUtils.join((Object[])executionCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
        }
        listener.getLogger().println("[WeblogicDeploymentPlugin] - ARTIFACT DEPLOYED SUCCESSFULLY.");
    }

    private String replaceTokens(String text, WebLogicDeployerParameters parameters) {
        Pattern pattern = Pattern.compile("\\{([^}]+)\\}");
        StringBuilder output = new StringBuilder();
        Matcher tokenMatcher = pattern.matcher(text);
        int cursor = 0;
        while (tokenMatcher.find()) {
            int tokenStart = tokenMatcher.start();
            int tokenEnd = tokenMatcher.end();
            int keyStart = tokenMatcher.start(1);
            int keyEnd = tokenMatcher.end(1);
            output.append(text.substring(cursor, tokenStart));
            String token = text.substring(tokenStart, tokenEnd);
            String key = text.substring(keyStart, keyEnd);
            String value = this.findValue(key, parameters);
            if (value != null) {
                output.append(value);
            } else {
                output.append(token);
            }
            cursor = tokenEnd;
        }
        output.append(text.substring(cursor));
        return output.toString();
    }

    private String findValue(String key, WebLogicDeployerParameters parameters) {
        String result = key;
        if (key.startsWith("wl.")) {
            return this.tokenResolver.resolveKey(key, parameters);
        }
        return result;
    }

    private WeblogicEnvironment getWeblogicEnvironmentTargeted(String weblogicEnvironmentTargetedName, BuildListener listener) {
        WeblogicEnvironment out = null;
        WeblogicEnvironment[] targets = this.getDescriptor().getWeblogicEnvironments();
        if (targets == null) {
            return out;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (!weblogicEnvironmentTargetedName.equalsIgnoreCase(targets[i].getName())) continue;
            out = targets[i];
            break;
        }
        return out;
    }

    public WeblogicDeploymentPlugin.WeblogicDeploymentPluginDescriptor getDescriptor() {
        return this.descriptor;
    }
}

