/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.data;

import org.codehaus.plexus.util.StringUtils;
import org.jenkinsci.plugins.deploy.weblogic.data.DeploymentTask;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicDeploymentStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicPreRequisteStatus;

public class DeploymentTaskResult {
    private WebLogicDeploymentStatus status;
    private WebLogicPreRequisteStatus check;
    private DeploymentTask task;
    private String resourceName;
    private static final String PLUGIN_EXECUTION_CHECK_FAILED = "PLUGIN_EXECUTION_CHECK_FAILED";

    public DeploymentTaskResult(WebLogicPreRequisteStatus check, WebLogicDeploymentStatus status, DeploymentTask task, String resourceName) {
        this.check = check;
        this.task = task;
        this.status = status;
        this.resourceName = resourceName;
    }

    public String getLabel() {
        String actionLabel = null;
        if (this.check != null && this.check != WebLogicPreRequisteStatus.OK) {
            return PLUGIN_EXECUTION_CHECK_FAILED;
        }
        if (StringUtils.isNotBlank((String)this.getResourceName())) {
            actionLabel = this.getResourceName();
        } else if (this.getTask() != null) {
            actionLabel = StringUtils.isNotBlank((String)this.getTask().getTaskName()) ? this.getTask().getTaskName() : this.getTask().getId();
        }
        if (this.getTask() != null) {
            return StringUtils.defaultString((Object)actionLabel, (String)"").concat("#").concat(StringUtils.defaultString((Object)this.getTask().getWeblogicEnvironmentTargetedName(), (String)""));
        }
        return StringUtils.defaultString((Object)actionLabel, (String)"");
    }

    public WebLogicDeploymentStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebLogicDeploymentStatus status) {
        this.status = status;
    }

    public DeploymentTask getTask() {
        return this.task;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public WebLogicPreRequisteStatus getCheck() {
        return this.check;
    }

    public void setCheck(WebLogicPreRequisteStatus check) {
        this.check = check;
    }
}

