/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeStyleJobArtifactSelectorImpl
implements ArtifactSelector {
    @Override
    public FilePath selectArtifactRecorded(AbstractBuild<?, ?> build, BuildListener listener, String filteredResource, String baseDirectory) throws IOException, XmlPullParserException, InterruptedException {
        FilePath selectedArtifact = null;
        listener.getLogger().println("[WeblogicDeploymentPlugin] - Retrieving artifacts recorded [filtered resources on " + filteredResource + "]...");
        ArrayList<FilePath> artifactsRecorded = new ArrayList<FilePath>();
        if (baseDirectory == null || !new File(baseDirectory).exists()) {
            FilePath workspace = build.getWorkspace();
            List filesInWorkspace = workspace.list();
            for (FilePath file : filesInWorkspace) {
                if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following artifact recorded " + file.getName() + " is eligible.");
                    artifactsRecorded.add(file);
                    continue;
                }
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following artifact " + file.getName() + " doesn't match " + filteredResource);
            }
        } else {
            Collection files = FileUtils.listFiles((File)new File(baseDirectory), null, (boolean)true);
            for (File file : files) {
                if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following file recorded " + file.getName() + " is eligible.");
                    artifactsRecorded.add(new FilePath(file));
                    continue;
                }
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following file " + file.getName() + " doesn't match " + filteredResource);
            }
        }
        if (artifactsRecorded.size() < 1) {
            throw new RuntimeException("[WeblogicDeploymentPlugin] - No artifact to deploy found.");
        }
        if (artifactsRecorded.size() > 1) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - More than 1 artifact found : The first one " + artifactsRecorded.get(0) + " will be deployed!!!");
        }
        if ((selectedArtifact = (FilePath)artifactsRecorded.get(0)) == null) {
            throw new RuntimeException("No artifact to deploy found.");
        }
        return selectedArtifact;
    }
}

