/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Delete
extends VSphereBuildStep {
    private final String vm;
    private final boolean failOnNoExist;

    @DataBoundConstructor
    public Delete(String vm, boolean failOnNoExist) throws VSphereException {
        this.failOnNoExist = failOnNoExist;
        this.vm = vm;
    }

    public String getVm() {
        return this.vm;
    }

    public boolean isFailOnNoExist() {
        return this.failOnNoExist;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        if (Delete.allowDelete()) {
            return this.killVm(build, launcher, listener);
        }
        VSphereLogger.vsLogger(listener.getLogger(), "Deletion is disabled!");
        return false;
    }

    private boolean killVm(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        VSphereLogger.vsLogger(jLogger, "Destroying VM \"" + expandedVm + ".\" Please wait ...");
        this.vsphere.destroyVm(expandedVm, this.failOnNoExist);
        VSphereLogger.vsLogger(jLogger, "Destroyed!");
        return true;
    }

    @Extension
    public static final class DeleteDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public DeleteDescriptor() {
            this.load();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_Delete();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = DeleteDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

