/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deploy
extends VSphereBuildStep {
    private final String template;
    private final String clone;
    private final boolean linkedClone;
    private final String resourcePool;
    private final String cluster;
    private final String datastore;

    @DataBoundConstructor
    public Deploy(String template, String clone, boolean linkedClone, String resourcePool, String cluster, String datastore) throws VSphereException {
        this.template = template;
        this.clone = clone;
        this.linkedClone = linkedClone;
        this.resourcePool = resourcePool;
        this.cluster = cluster;
        this.datastore = datastore;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getClone() {
        return this.clone;
    }

    public boolean isLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        return this.deployFromTemplate(build, launcher, listener);
    }

    private boolean deployFromTemplate(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedClone = env.expand(this.clone);
        String expandedTemplate = env.expand(this.template);
        String expandedCluster = env.expand(this.cluster);
        String expandedDatastore = env.expand(this.datastore);
        String resourcePoolName = this.resourcePool.length() == 0 ? "Resources" : env.expand(this.resourcePool);
        this.vsphere.deployVm(expandedClone, expandedTemplate, this.linkedClone, resourcePoolName, expandedCluster, expandedDatastore, jLogger);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedClone + "\" successfully deployed!");
        return true;
    }

    @Extension
    public static final class DeployDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public DeployDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_Deploy();
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the template name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClone(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the clone name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String template, @QueryParameter String clone, @QueryParameter String resourcePool, @QueryParameter String cluster) {
            try {
                if (template.length() == 0 || clone.length() == 0 || serverName.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = DeployDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine cloneVM = vsphere.getVmByName(clone);
                if (cloneVM != null) {
                    return FormValidation.error((String)Messages.validation_exists("clone"));
                }
                if (template.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("template"));
                }
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("template"));
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("template"));
                }
                VirtualMachineSnapshot snap = vm.getCurrentSnapShot();
                if (snap == null) {
                    return FormValidation.error((String)Messages.validation_noSnapshots());
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

