/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import com.vmware.vim25.CustomizationSpecItem;
import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodFault;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineQuestionInfo;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.CustomizationSpecManager;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.DistributedVirtualSwitch;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.tools.VSphereDuplicateException;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.jenkinsci.plugins.vsphere.tools.VSphereNotFoundException;

public class VSphere {
    private final URL url;
    private final String session;
    private static final Logger LOGGER = Logger.getLogger(VSphere.class.getName());

    private VSphere(@NonNull String url, boolean ignoreCert, @NonNull String user, @CheckForNull String pw) throws VSphereException {
        try {
            this.url = new URL(url);
            ServiceInstance serviceInstance = new ServiceInstance(this.url, user, pw, ignoreCert);
            ServerConnection serverConnection = serviceInstance.getServerConnection();
            this.session = serverConnection.getSessionStr();
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private ServiceInstance getServiceInstance() throws RemoteException, MalformedURLException {
        return new ServiceInstance(this.url, this.session, true);
    }

    public static VSphere connect(@NonNull VSphereConnectionConfig connectionDetails) throws VSphereException {
        String server = connectionDetails.getVsHost() + "/sdk";
        boolean ignoreCert = connectionDetails.getAllowUntrustedCertificate();
        String user = connectionDetails.getUsername();
        String pw = connectionDetails.getPassword();
        return new VSphere(server, ignoreCert, user, pw);
    }

    @Deprecated
    public static VSphere connect(@NonNull String server, boolean ignoreCert, @NonNull String user, @CheckForNull String pw) throws VSphereException {
        return new VSphere(server, ignoreCert, user, pw);
    }

    public void disconnect() {
        try {
            this.getServiceInstance().getServerConnection().logout();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Caught exception when trying to disconnect vSphere.", e);
        }
    }

    public void deployVm(String cloneName, String sourceName, boolean linkedClone, String resourcePoolName, String cluster, String datastoreName, String folderName, boolean powerOn, String customizationSpec, PrintStream jLogger) throws VSphereException {
        boolean useCurrentSnapshotIsFALSE = false;
        String namedSnapshotIsNULL = null;
        Map<String, String> extraConfigParameters = null;
        this.logMessage(jLogger, "Deploying new vm \"" + cloneName + "\" from template \"" + sourceName + "\"");
        this.cloneOrDeployVm(cloneName, sourceName, linkedClone, resourcePoolName, cluster, datastoreName, folderName, false, namedSnapshotIsNULL, powerOn, extraConfigParameters, customizationSpec, jLogger);
    }

    public void cloneVm(String cloneName, String sourceName, boolean linkedClone, String resourcePoolName, String cluster, String datastoreName, String folderName, boolean powerOn, String customizationSpec, PrintStream jLogger) throws VSphereException {
        boolean useCurrentSnapshotIsTRUE = true;
        String namedSnapshotIsNULL = null;
        Map<String, String> extraConfigParameters = null;
        this.logMessage(jLogger, "Creating a " + (linkedClone ? "shallow" : "deep") + " clone of \"" + sourceName + "\" to \"" + cloneName + "\"");
        this.cloneOrDeployVm(cloneName, sourceName, linkedClone, resourcePoolName, cluster, datastoreName, folderName, true, namedSnapshotIsNULL, powerOn, extraConfigParameters, customizationSpec, jLogger);
    }

    public void cloneOrDeployVm(String cloneName, String sourceName, boolean linkedClone, String resourcePoolName, String cluster, String datastoreName, String folderName, boolean useCurrentSnapshot, String namedSnapshot, boolean powerOn, Map<String, String> extraConfigParameters, String customizationSpec, PrintStream jLogger) throws VSphereException {
        try {
            Folder folder;
            VirtualMachine sourceVm = this.getVmByName(sourceName);
            if (sourceVm == null) {
                throw new VSphereNotFoundException("VM or template", sourceName);
            }
            if (this.getVmByName(cloneName) != null) {
                throw new VSphereDuplicateException("VM", cloneName);
            }
            VirtualMachineConfigInfo vmConfig = sourceVm.getConfig();
            boolean sourceIsATemplate = vmConfig.template;
            String sourceType = sourceIsATemplate ? "Template" : "VM";
            VirtualMachineRelocateSpec rel = this.createRelocateSpec(jLogger, linkedClone, resourcePoolName, cluster, datastoreName, sourceIsATemplate);
            VirtualMachineCloneSpec cloneSpec = this.createCloneSpec(rel);
            cloneSpec.setTemplate(false);
            cloneSpec.powerOn = powerOn;
            if (namedSnapshot != null && !namedSnapshot.isEmpty()) {
                if (useCurrentSnapshot) {
                    throw new IllegalArgumentException("It is not valid to request a clone of " + sourceType + "  \"" + sourceName + "\" based on its snapshot \"" + namedSnapshot + "\" AND also specify that the latest snapshot should be used.  Either choose to use the latest snapshot, or name a snapshot, or neither, but not both.");
                }
                VirtualMachineSnapshot namedVMSnapshot = this.getSnapshotInTree(sourceVm, namedSnapshot);
                if (namedVMSnapshot == null) {
                    throw new VSphereNotFoundException("Snapshot", namedSnapshot, "Source " + sourceType + "  \"" + sourceName + "\" has no snapshot called \"" + namedSnapshot + "\".");
                }
                this.logMessage(jLogger, "Clone of " + sourceType + " \"" + sourceName + "\" will be based on named snapshot \"" + namedSnapshot + "\".");
                cloneSpec.setSnapshot(namedVMSnapshot.getMOR());
            }
            if (useCurrentSnapshot) {
                VirtualMachineSnapshot currentSnapShot = sourceVm.getCurrentSnapShot();
                if (currentSnapShot == null) {
                    throw new VSphereNotFoundException("Snapshot", null, "Source " + sourceType + "  \"" + sourceName + "\" requires at least one snapshot.");
                }
                this.logMessage(jLogger, "Clone of " + sourceType + " \"" + sourceName + "\" will be based on current snapshot \"" + currentSnapShot.toString() + "\".");
                cloneSpec.setSnapshot(currentSnapShot.getMOR());
            }
            if (extraConfigParameters != null && !extraConfigParameters.isEmpty()) {
                this.logMessage(jLogger, "Clone of " + sourceType + " \"" + sourceName + "\" will have extra configuration parameters " + extraConfigParameters + ".");
                VirtualMachineConfigSpec cs = VSphere.createVMConfigSpecFromExtraConfigParameters(extraConfigParameters);
                cloneSpec.setConfig(cs);
            }
            if (customizationSpec != null && customizationSpec.length() > 0) {
                this.logMessage(jLogger, "Clone of " + sourceType + " \"" + sourceName + "\" will use customization specification \"" + customizationSpec + "\".");
                CustomizationSpecItem spec = this.getCustomizationSpecByName(customizationSpec);
                cloneSpec.setCustomization(spec.getSpec());
            }
            if (folderName == null || folderName.isEmpty() || folderName.equals(" ")) {
                folder = (Folder)sourceVm.getParent();
            } else if (!this.folderExists(folderName).booleanValue()) {
                folder = (Folder)sourceVm.getParent();
                this.logMessage(jLogger, "Unable to find the specified folder. Creating VM in the same folder as its parent ");
            } else {
                folder = this.getFolder(folderName);
            }
            Task task = sourceVm.cloneVM_Task(folder, cloneName, cloneSpec);
            this.logMessage(jLogger, "Started cloning of " + sourceType + " \"" + sourceName + "\". Please wait ...");
            String status = task.waitForTask();
            if (!TaskInfoState.success.toString().equals(status)) {
                throw VSphere.newVSphereException(task.getTaskInfo(), "Couldn't clone \"" + sourceName + "\". Clone task ended with status " + status + ".");
            }
            this.logMessage(jLogger, "Successfully cloned VM \"" + sourceName + "\" to create \"" + cloneName + "\".");
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private VirtualMachineCloneSpec createCloneSpec(VirtualMachineRelocateSpec rel) {
        VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
        cloneSpec.setLocation(rel);
        cloneSpec.setTemplate(false);
        cloneSpec.setPowerOn(true);
        return cloneSpec;
    }

    private VirtualMachineRelocateSpec createRelocateSpec(PrintStream jLogger, boolean linkedClone, String resourcePoolName, String cluster, String datastoreName, boolean isResourcePoolRequired) throws RemoteException, MalformedURLException, VSphereException {
        VirtualMachineRelocateSpec rel = new VirtualMachineRelocateSpec();
        if (linkedClone) {
            rel.setDiskMoveType("createNewChildDiskBacking");
        } else {
            rel.setDiskMoveType("moveAllDiskBackingsAndDisallowSharing");
        }
        ClusterComputeResource clusterResource = this.getClusterByName(cluster);
        if (clusterResource == null && StringUtils.isNotBlank((String)cluster)) {
            this.logMessage(jLogger, "Cluster resource " + cluster + " does not exist, root folder will be used for getting resource pool and datastore");
        }
        if (resourcePoolName != null && !resourcePoolName.isEmpty()) {
            ResourcePool resourcePool = this.getResourcePoolByName(resourcePoolName, (ManagedEntity)clusterResource);
            if (resourcePool == null) {
                throw new VSphereNotFoundException("Resource pool", resourcePoolName);
            }
            rel.setPool(resourcePool.getMOR());
        } else if (isResourcePoolRequired) {
            throw new VSphereException("You must specify a resource  pool  when using a template");
        }
        if (datastoreName != null && !datastoreName.isEmpty()) {
            Datastore datastore = this.getDatastoreByName(datastoreName, (ManagedEntity)clusterResource);
            if (datastore == null) {
                throw new VSphereNotFoundException("Datastore", datastoreName);
            }
            rel.setDatastore(datastore.getMOR());
        }
        return rel;
    }

    public void reconfigureVm(String name, VirtualMachineConfigSpec spec) throws VSphereException {
        VirtualMachine vm = this.getVmByName(name);
        if (vm == null) {
            throw new VSphereNotFoundException("VM or template", name);
        }
        LOGGER.log(Level.FINER, "Reconfiguring VM. Please wait ...");
        try {
            Task task = vm.reconfigVM_Task(spec);
            String status = task.waitForTask();
            if (status.equals(TaskInfoState.success.toString())) {
                return;
            }
            throw VSphere.newVSphereException(task.getTaskInfo(), "Couldn't reconfigure \"" + name + "\"!");
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException("VM cannot be reconfigured:" + e.getMessage(), e);
        }
    }

    public void startVm(String name, int timeoutInSeconds) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                throw new VSphereNotFoundException("VM", name);
            }
            if (this.isPoweredOn(vm)) {
                return;
            }
            if (vm.getConfig().template) {
                throw new VSphereException("VM represents a template!");
            }
            Task task = vm.powerOnVM_Task(null);
            int timesToCheck = timeoutInSeconds / 5;
            LOGGER.log(Level.FINER, "Checking " + ++timesToCheck + " times for vm to be powered on");
            for (int i = 0; i < timesToCheck; ++i) {
                VirtualMachineQuestionInfo q;
                if (task.getTaskInfo().getState() == TaskInfoState.success) {
                    LOGGER.log(Level.FINER, "VM was powered up successfully.");
                    return;
                }
                if (task.getTaskInfo().getState() == TaskInfoState.running || task.getTaskInfo().getState() == TaskInfoState.queued) {
                    Thread.sleep(5000L);
                }
                if ((q = vm.getRuntime().getQuestion()) == null || !q.getId().equals("_vmx1")) continue;
                vm.answerVM(q.getId(), q.getChoice().getDefaultIndex().toString());
                return;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new VSphereException("VM cannot be started: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new VSphereException("VM cannot be started: " + e.getMessage(), e);
        }
        throw new VSphereException("VM cannot be started");
    }

    private ManagedObjectReference findSnapshotInTree(VirtualMachineSnapshotTree[] snapTree, String snapName) {
        LOGGER.log(Level.FINER, "Looking for snapshot " + snapName);
        for (VirtualMachineSnapshotTree node : snapTree) {
            ManagedObjectReference mor;
            if (snapName.equals(node.getName())) {
                return node.getSnapshot();
            }
            VirtualMachineSnapshotTree[] childTree = node.getChildSnapshotList();
            if (childTree == null || (mor = this.findSnapshotInTree(childTree, snapName)) == null) continue;
            return mor;
        }
        return null;
    }

    public VirtualMachineSnapshot getSnapshotInTree(VirtualMachine vm, String snapName) {
        ManagedObjectReference mor;
        VirtualMachineSnapshotTree[] snapTree;
        if (vm == null || snapName == null) {
            return null;
        }
        LOGGER.log(Level.FINER, "Looking for snapshot " + snapName + " in " + vm.getName());
        VirtualMachineSnapshotInfo info = vm.getSnapshot();
        if (info != null && (snapTree = info.getRootSnapshotList()) != null && (mor = this.findSnapshotInTree(snapTree, snapName)) != null) {
            return new VirtualMachineSnapshot(vm.getServerConnection(), mor);
        }
        return null;
    }

    public void revertToSnapshot(String vmName, String snapName) throws VSphereException {
        VirtualMachine vm = this.getVmByName(vmName);
        VirtualMachineSnapshot snap = this.getSnapshotInTree(vm, snapName);
        if (snap == null) {
            LOGGER.log(Level.SEVERE, "Cannot find snapshot: '" + snapName + "' for virtual machine: '" + vm.getName() + "'");
            throw new VSphereNotFoundException("Snapshot", snapName);
        }
        try {
            Task task = snap.revertToSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                String msg = "Could not revert to snapshot '" + snap.toString() + "' for virtual machine:'" + vm.getName() + "'";
                LOGGER.log(Level.SEVERE, msg);
                throw VSphere.newVSphereException(task.getTaskInfo(), msg);
            }
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public void deleteSnapshot(String vmName, String snapName, boolean consolidate, boolean failOnNoExist) throws VSphereException {
        VirtualMachine vm = this.getVmByName(vmName);
        VirtualMachineSnapshot snap = this.getSnapshotInTree(vm, snapName);
        if (snap == null && failOnNoExist) {
            throw new VSphereNotFoundException("Snapshot", snapName);
        }
        try {
            Task task;
            if (snap != null && !(task = snap.removeSnapshot_Task(false)).waitForTask().equals("success")) {
                throw VSphere.newVSphereException(task.getTaskInfo(), "Could not delete snapshot");
            }
            if (!consolidate) {
                return;
            }
            task = vm.consolidateVMDisks_Task();
            if (!task.waitForTask().equals("success")) {
                throw VSphere.newVSphereException(task.getTaskInfo(), "Could not consolidate VM disks");
            }
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public void takeSnapshot(String vmName, String snapshot, String description, boolean snapMemory) throws VSphereException {
        String message = "Could not take snapshot";
        VirtualMachine vmToSnapshot = this.getVmByName(vmName);
        if (vmToSnapshot == null) {
            throw new VSphereNotFoundException("VM", vmName);
        }
        try {
            Task task = vmToSnapshot.createSnapshot_Task(snapshot, description, snapMemory, !snapMemory);
            if (task.waitForTask().equals("success")) {
                return;
            }
            throw VSphere.newVSphereException(task.getTaskInfo(), "Could not take snapshot");
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException("Could not take snapshot", e);
        }
    }

    public void markAsTemplate(String vmName, String snapName, boolean force) throws VSphereException {
        String message = "Could not mark as Template. Check it's power state or select \"force.\"";
        try {
            VirtualMachine vm = this.getVmByName(vmName);
            if (vm.getConfig().template) {
                return;
            }
            if (this.isPoweredOff(vm) || force) {
                this.powerOffVm(vm, force, 0);
                vm.markAsTemplate();
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not mark as Template. Check it's power state or select \"force.\"", e);
        }
        throw new VSphereException("Could not mark as Template. Check it's power state or select \"force.\"");
    }

    public void markAsVm(String name, String resourcePool, String cluster) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (vm.getConfig().template) {
                vm.markAsVirtualMachine(this.getResourcePoolByName(resourcePool, (ManagedEntity)this.getClusterByName(cluster)), null);
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not convert to VM", e);
        }
    }

    public String getIp(VirtualMachine vm, int timeout) throws VSphereException {
        if (vm == null) {
            throw new VSphereException("VM is null");
        }
        int waitSeconds = 5;
        int maxTries = timeout <= 5 ? 1 : (int)Math.round((double)timeout / 5.0);
        for (int count = 0; count < maxTries; ++count) {
            GuestInfo guestInfo = vm.getGuest();
            if (guestInfo != null && guestInfo.getIpAddress() != null) {
                return guestInfo.getIpAddress();
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    public VirtualMachine getVmByName(String vmName) throws VSphereException {
        try {
            return (VirtualMachine)new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntity("VirtualMachine", vmName);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public int countVms() throws VSphereException {
        int count = 0;
        try {
            InventoryNavigator navigator = new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder());
            ManagedEntity[] entities = navigator.searchManagedEntities(false);
            count = entities.length;
        }
        catch (Exception ex) {
            throw new VSphereException(ex);
        }
        return count;
    }

    public int countVmsByPrefix(String prefix) throws VSphereException {
        int count = 0;
        try {
            ManagedEntity[] entities;
            InventoryNavigator navigator = new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder());
            for (ManagedEntity entity : entities = navigator.searchManagedEntities(false)) {
                if (!entity.getName().startsWith(prefix)) continue;
                ++count;
            }
        }
        catch (Exception ex) {
            throw new VSphereException(ex);
        }
        return count;
    }

    private Datastore getDatastoreByName(String datastoreName, ManagedEntity rootEntity) throws RemoteException, MalformedURLException {
        Datastore datastore;
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        if ((datastore = (Datastore)new InventoryNavigator(rootEntity).searchManagedEntity("Datastore", datastoreName)) != null) {
            return datastore;
        }
        if (rootEntity == null || !(rootEntity instanceof ClusterComputeResource)) {
            return null;
        }
        ClusterComputeResource clusterResource = (ClusterComputeResource)rootEntity;
        for (Datastore dataStore : clusterResource.getDatastores()) {
            if (!dataStore.getName().equals(datastoreName)) continue;
            return dataStore;
        }
        return null;
    }

    public Boolean folderExists(String folderPath) throws VSphereException {
        try {
            String[] folderHierarchy = folderPath.split("/");
            ManagedEntity folder = null;
            for (int i = 0; i < folderHierarchy.length; ++i) {
                folder = i == 0 ? new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntity("Folder", folderHierarchy[i]) : new InventoryNavigator(folder).searchManagedEntity(null, folderHierarchy[i]);
                if (folder != null) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed while checking if folder exists");
            throw new VSphereException(e);
        }
    }

    public Folder getFolder(String folderPath) throws VSphereException {
        try {
            String[] folderHierarchy = folderPath.split("/");
            ManagedEntity folder = null;
            for (int i = 0; i < folderHierarchy.length; ++i) {
                folder = i == 0 ? new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntity("Folder", folderHierarchy[i]) : new InventoryNavigator(folder).searchManagedEntity(null, folderHierarchy[i]);
            }
            return (Folder)folder;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Invalid folder");
            throw new VSphereException(e);
        }
    }

    public CustomizationSpecItem getCustomizationSpecByName(String customizationSpecName) throws VSphereException {
        try {
            ServerConnection conn = this.getServiceInstance().getServerConnection();
            CustomizationSpecManager mgr = new CustomizationSpecManager(conn, this.getServiceInstance().getServiceContent().customizationSpecManager);
            return mgr.getCustomizationSpec(customizationSpecName);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public ManagedEntity[] getDatastores() throws VSphereException {
        try {
            return new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntities("Datastore");
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private ResourcePool getResourcePoolByName(String poolName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ResourcePool)new InventoryNavigator(rootEntity).searchManagedEntity("ResourcePool", poolName);
    }

    private ClusterComputeResource getClusterByName(String clusterName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ClusterComputeResource)new InventoryNavigator(rootEntity).searchManagedEntity("ClusterComputeResource", clusterName);
    }

    private ClusterComputeResource getClusterByName(String clusterName) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        return this.getClusterByName(clusterName, null);
    }

    public void destroyVm(String name, boolean failOnNoExist) throws VSphereException {
        try {
            Task task;
            String status;
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                if (failOnNoExist) {
                    throw new VSphereNotFoundException("VM", name);
                }
                LOGGER.log(Level.FINER, "VM \"" + name + "\" does not exist, or already deleted!");
                return;
            }
            if (!vm.getConfig().template) {
                this.powerOffVm(vm, true, 0);
            }
            if ((status = (task = vm.destroy_Task()).waitForTask()).equals("success")) {
                LOGGER.log(Level.FINER, "VM \"" + name + "\" was deleted successfully.");
                return;
            }
            throw VSphere.newVSphereException(task.getTaskInfo(), "Could not delete VM \"" + name + "\"!");
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage(), e);
        }
    }

    public void renameVmSnapshot(String vmName, String oldName, String newName, String newDescription) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(vmName);
            if (vm == null) {
                throw new VSphereNotFoundException("VM", vmName);
            }
            VirtualMachineSnapshot snapshot = this.getSnapshotInTree(vm, oldName);
            snapshot.renameSnapshot(newName, newDescription);
            LOGGER.log(Level.FINER, "VM Snapshot was renamed successfully.");
            return;
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage(), e);
        }
    }

    public void renameVm(String oldName, String newName) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(oldName);
            if (vm == null) {
                throw new VSphereNotFoundException("VM", oldName);
            }
            Task task = vm.rename_Task(newName);
            String status = task.waitForTask();
            if (status.equals("success")) {
                LOGGER.log(Level.FINER, "VM was renamed successfully.");
                return;
            }
            throw VSphere.newVSphereException(task.getTaskInfo(), "Could not rename VM \"" + oldName + "\"!");
        }
        catch (RuntimeException | VSphereException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage(), e);
        }
    }

    private boolean isSuspended(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.suspended;
    }

    private boolean isPoweredOn(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn;
    }

    private boolean isPoweredOff(VirtualMachine vm) {
        return vm.getRuntime() != null && vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff;
    }

    public boolean vmToolIsEnabled(VirtualMachine vm) {
        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
        return status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld;
    }

    @Deprecated
    public void powerOffVm(VirtualMachine vm, boolean evenIfSuspended, boolean shutdownGracefully) throws VSphereException {
        this.powerOffVm(vm, evenIfSuspended, shutdownGracefully ? 180 : 0);
    }

    public void powerOffVm(VirtualMachine vm, boolean evenIfSuspended, int gracefulShutdownSeconds) throws VSphereException {
        block12: {
            if (vm.getConfig().template) {
                throw new VSphereException("VM represents a template!");
            }
            if (this.isPoweredOn(vm) || evenIfSuspended && this.isSuspended(vm)) {
                boolean doHardShutdown = true;
                try {
                    if (!this.isSuspended(vm) && gracefulShutdownSeconds > 0 && this.vmToolIsEnabled(vm)) {
                        LOGGER.log(Level.FINER, "Requesting guest shutdown");
                        vm.shutdownGuest();
                        for (int i = 0; i <= gracefulShutdownSeconds; ++i) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new VSphereException("VM power-down interrupted", e);
                            }
                            if (!this.isPoweredOff(vm)) continue;
                            doHardShutdown = false;
                            LOGGER.log(Level.FINER, "VM gracefully powered down successfully.");
                            return;
                        }
                    }
                    if (doHardShutdown) {
                        LOGGER.log(Level.FINER, "Powering off the VM");
                        Task task = vm.powerOffVM_Task();
                        String status = task.waitForTask();
                        if (status.equals("success")) {
                            LOGGER.log(Level.FINER, "VM was powered down successfully.");
                            return;
                        }
                        throw VSphere.newVSphereException(task.getTaskInfo(), "Machine could not be powered down!");
                    }
                    break block12;
                }
                catch (RuntimeException | VSphereException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VSphereException(e);
                }
            }
            if (this.isPoweredOff(vm)) {
                LOGGER.log(Level.FINER, "Machine is already off.");
                return;
            }
        }
        throw new VSphereException("Machine could not be powered down!");
    }

    public void suspendVm(VirtualMachine vm) throws VSphereException {
        if (this.isPoweredOn(vm)) {
            try {
                Task task = vm.suspendVM_Task();
                String status = task.waitForTask();
                if ("success".equals(status)) {
                    LOGGER.log(Level.FINER, "VM was suspended successfully.");
                    return;
                }
                throw VSphere.newVSphereException(task.getTaskInfo(), "Machine could not be suspended!");
            }
            catch (RuntimeException | VSphereException e) {
                throw e;
            }
            catch (Exception e) {
                throw new VSphereException(e);
            }
        }
        LOGGER.log(Level.FINER, "Machine not powered on.");
    }

    private Datacenter getDataCenter(ManagedEntity managedEntity) {
        if (managedEntity != null) {
            ManagedEntity parent = managedEntity.getParent();
            if (parent.getMOR().getType().equals("Datacenter")) {
                return (Datacenter)parent;
            }
            return this.getDataCenter(managedEntity.getParent());
        }
        return null;
    }

    public Network getNetworkPortGroupByName(VirtualMachine virtualMachine, String name) throws VSphereException {
        try {
            Datacenter datacenter = this.getDataCenter((ManagedEntity)virtualMachine);
            for (Network network : datacenter.getNetworks()) {
                if (!(network instanceof Network) || !name.isEmpty() && !network.getName().contentEquals(name)) continue;
                return network;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        return null;
    }

    public DistributedVirtualPortgroup getDistributedVirtualPortGroupByName(VirtualMachine virtualMachine, String name) throws VSphereException {
        try {
            Datacenter datacenter = this.getDataCenter((ManagedEntity)virtualMachine);
            for (Network network : datacenter.getNetworks()) {
                if (!(network instanceof DistributedVirtualPortgroup) || !name.isEmpty() && !network.getName().contentEquals(name)) continue;
                return (DistributedVirtualPortgroup)network;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        return null;
    }

    public DistributedVirtualSwitch getDistributedVirtualSwitchByPortGroup(DistributedVirtualPortgroup distributedVirtualPortgroup) throws VSphereException {
        try {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType("DistributedVirtualSwitch");
            managedObjectReference.setVal(distributedVirtualPortgroup.getConfig().getDistributedVirtualSwitch().getVal());
            return new DistributedVirtualSwitch(this.getServiceInstance().getServerConnection(), managedObjectReference);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public void setExtraConfigParameters(String vmName, Map<String, String> parameters) throws VSphereException {
        VirtualMachineConfigSpec cs = VSphere.createVMConfigSpecFromExtraConfigParameters(parameters);
        this.reconfigureVm(vmName, cs);
    }

    private static VirtualMachineConfigSpec createVMConfigSpecFromExtraConfigParameters(Map<String, String> parameters) {
        VirtualMachineConfigSpec cs = new VirtualMachineConfigSpec();
        OptionValue[] ourOptionValues = new OptionValue[parameters.size()];
        ArrayList<OptionValue> optionValues = new ArrayList<OptionValue>();
        for (Map.Entry<String, String> eachVariable : parameters.entrySet()) {
            OptionValue ov = new OptionValue();
            ov.setKey(eachVariable.getKey());
            ov.setValue((Object)eachVariable.getValue());
            optionValues.add(ov);
        }
        for (int i = 0; i < optionValues.size(); ++i) {
            ourOptionValues[i] = (OptionValue)optionValues.get(i);
        }
        cs.setExtraConfig(ourOptionValues);
        return cs;
    }

    private void logMessage(PrintStream jLogger, String message) {
        if (jLogger != null) {
            VSphereLogger.vsLogger(jLogger, message);
        }
        LOGGER.log(Level.FINER, message);
    }

    private static VSphereException newVSphereException(TaskInfo taskInfo, String message) {
        LocalizedMethodFault error = taskInfo == null ? null : taskInfo.getError();
        String faultMsg = error == null ? null : error.getLocalizedMessage();
        MethodFault fault = error == null ? null : error.getFault();
        String combinedMsg = message + (faultMsg == null ? "" : "\n" + faultMsg);
        if (fault != null) {
            return new VSphereException(combinedMsg, (Throwable)fault);
        }
        return new VSphereException(combinedMsg);
    }
}

