/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SuspendVm
extends VSphereBuildStep
implements SimpleBuildStep {
    private final String vm;

    @DataBoundConstructor
    public SuspendVm(String vm) throws VSphereException {
        this.vm = vm;
    }

    public String getVm() {
        return this.vm;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.suspend(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.suspend((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    private boolean suspend(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
        }
        VSphereLogger.vsLogger(jLogger, "Suspending VM...");
        this.vsphere.suspendVm(this.vsphere.getVmByName(expandedVm));
        VSphereLogger.vsLogger(jLogger, "Successfully suspended \"" + expandedVm + "\"");
        return true;
    }

    @Extension
    public static class SuspendVmDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_SuspendVM();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VSphere vsphere = SuspendVmDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                if (vsphere.getVmByName(vm) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

