/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.mo.VirtualMachine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;

public abstract class ReconfigureStep
extends AbstractDescribableImpl<ReconfigureStep>
implements ExtensionPoint {
    protected VirtualMachineConfigSpec spec;
    protected VirtualMachine vm;
    protected VSphere vsphere;

    public VSphere getVsphere() {
        return this.vsphere;
    }

    public void setVsphere(VSphere vsphere) {
        this.vsphere = vsphere;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public void setVM(VirtualMachine vm) {
        this.vm = vm;
    }

    public VirtualMachineConfigSpec getVirtualMachineConfigSpec() {
        return this.spec;
    }

    public void setVirtualMachineConfigSpec(VirtualMachineConfigSpec spec) {
        this.spec = spec;
    }

    public static List<ReconfigureStepDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(ReconfigureStep.class);
    }

    public abstract boolean perform(AbstractBuild<?, ?> var1, Launcher var2, BuildListener var3) throws VSphereException;

    public abstract void perform(@NonNull Run<?, ?> var1, FilePath var2, @NonNull Launcher var3, @NonNull TaskListener var4) throws InterruptedException, IOException;

    protected VirtualDevice findDeviceByLabel(VirtualDevice[] devices, String label) {
        for (VirtualDevice d : devices) {
            if (!d.getDeviceInfo().getLabel().contentEquals(label)) continue;
            return d;
        }
        return null;
    }

    public static enum DeviceAction {
        ADD(Messages.vm_reconfigure_Add()){}
        ,
        EDIT(Messages.vm_reconfigure_Edit()){}
        ,
        REMOVE(Messages.vm_reconfigure_Remove()){};

        private final String label;

        private DeviceAction(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String __toString() {
            return this.getLabel();
        }
    }

    public static abstract class ReconfigureStepDescriptor
    extends Descriptor<ReconfigureStep> {
        protected ReconfigureStepDescriptor() {
        }

        protected ReconfigureStepDescriptor(Class<? extends ReconfigureStep> clazz) {
            super(clazz);
        }
    }
}

