/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.Description;
import com.vmware.vim25.DistributedVirtualSwitchPortConnection;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualE1000;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardDistributedVirtualPortBackingInfo;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.mo.DistributedVirtualPortgroup;
import com.vmware.vim25.mo.DistributedVirtualSwitch;
import com.vmware.vim25.mo.Network;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReconfigureNetworkAdapters
extends ReconfigureStep {
    private final ReconfigureStep.DeviceAction deviceAction;
    private final String deviceLabel;
    private final String macAddress;
    private final boolean standardSwitch;
    private final String portGroup;
    private final boolean distributedSwitch;
    private final String distributedPortGroup;
    private final String distributedPortId;

    @DataBoundConstructor
    public ReconfigureNetworkAdapters(ReconfigureStep.DeviceAction deviceAction, String deviceLabel, String macAddress, boolean standardSwitch, String portGroup, boolean distributedSwitch, String distributedPortGroup, String distributedPortId) throws VSphereException {
        this.deviceAction = deviceAction;
        this.deviceLabel = deviceLabel;
        this.macAddress = macAddress;
        this.standardSwitch = standardSwitch;
        this.portGroup = standardSwitch ? portGroup : null;
        this.distributedSwitch = distributedSwitch;
        this.distributedPortGroup = distributedSwitch ? distributedPortGroup : null;
        this.distributedPortId = distributedSwitch ? distributedPortId : null;
    }

    public ReconfigureStep.DeviceAction getDeviceAction() {
        return this.deviceAction;
    }

    public String getDeviceLabel() {
        return this.deviceLabel;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public boolean isStandardSwitch() {
        return this.standardSwitch;
    }

    public boolean isDistributedSwitch() {
        return this.distributedSwitch;
    }

    public String getPortGroup() {
        return this.portGroup;
    }

    public String getDistributedPortGroup() {
        return this.distributedPortGroup;
    }

    public String getDistributedPortId() {
        return this.distributedPortId;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.reconfigureNetwork(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.reconfigureNetwork((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public boolean reconfigureNetwork(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedDeviceLabel = this.deviceLabel;
        String expandedMacAddress = this.macAddress;
        String expandedPortGroup = this.portGroup;
        String expandedDistributedPortGroup = this.distributedPortGroup;
        String expandedDistributedPortId = this.distributedPortId;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedDeviceLabel = env.expand(this.deviceLabel);
            expandedMacAddress = env.expand(this.macAddress);
            expandedPortGroup = env.expand(this.portGroup);
            expandedDistributedPortGroup = env.expand(this.distributedPortGroup);
            expandedDistributedPortId = env.expand(this.distributedPortId);
        }
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: " + this.deviceAction.getLabel() + " Network Adapter \"" + expandedDeviceLabel + "\"");
        VirtualE1000 vEth = null;
        if (this.deviceAction == ReconfigureStep.DeviceAction.ADD) {
            vEth = new VirtualE1000();
            vEth.setBacking((VirtualDeviceBackingInfo)new VirtualEthernetCardNetworkBackingInfo());
            Description description = vEth.getDeviceInfo();
            if (description == null) {
                description = new Description();
            }
            description.setLabel(expandedDeviceLabel);
            vEth.setDeviceInfo(description);
        } else {
            vEth = this.findNetworkDeviceByLabel(this.vm.getConfig().getHardware().getDevice(), expandedDeviceLabel);
        }
        if (vEth == null) {
            throw new VSphereException("Could not find network device named " + expandedDeviceLabel);
        }
        if (!expandedMacAddress.isEmpty()) {
            VSphereLogger.vsLogger(jLogger, "Reconfiguring MAC Address -> " + expandedMacAddress);
            vEth.setMacAddress(expandedMacAddress);
        }
        VirtualDeviceBackingInfo virtualDeviceBackingInfo = vEth.getBacking();
        if (this.standardSwitch && !expandedPortGroup.isEmpty()) {
            VSphereLogger.vsLogger(jLogger, "Reconfiguring Network Port Group -> " + expandedPortGroup);
            if (virtualDeviceBackingInfo instanceof VirtualEthernetCardNetworkBackingInfo) {
                VirtualEthernetCardNetworkBackingInfo backing = (VirtualEthernetCardNetworkBackingInfo)virtualDeviceBackingInfo;
                Network networkPortGroup = this.getVsphere().getNetworkPortGroupByName(this.getVM(), expandedPortGroup);
                if (networkPortGroup != null) {
                    backing.deviceName = expandedPortGroup;
                } else {
                    VSphereLogger.vsLogger(jLogger, "Failed to find Network for Port Group -> " + expandedPortGroup);
                }
            } else {
                VSphereLogger.vsLogger(jLogger, "Network Device -> " + expandedDeviceLabel + " isn't standard switch");
            }
        } else if (this.distributedSwitch && !expandedDistributedPortGroup.isEmpty()) {
            VSphereLogger.vsLogger(jLogger, "Reconfiguring Distributed Switch Port Group -> " + expandedDistributedPortGroup + " Port Id -> " + expandedDistributedPortId);
            if (virtualDeviceBackingInfo instanceof VirtualEthernetCardDistributedVirtualPortBackingInfo) {
                VirtualEthernetCardDistributedVirtualPortBackingInfo virtualEthernetCardDistributedVirtualPortBackingInfo = (VirtualEthernetCardDistributedVirtualPortBackingInfo)virtualDeviceBackingInfo;
                DistributedVirtualPortgroup distributedVirtualPortgroup = this.getVsphere().getDistributedVirtualPortGroupByName(this.getVM(), expandedDistributedPortGroup);
                if (distributedVirtualPortgroup != null) {
                    DistributedVirtualSwitch distributedVirtualSwitch = this.getVsphere().getDistributedVirtualSwitchByPortGroup(distributedVirtualPortgroup);
                    DistributedVirtualSwitchPortConnection distributedVirtualSwitchPortConnection = new DistributedVirtualSwitchPortConnection();
                    distributedVirtualSwitchPortConnection.setSwitchUuid(distributedVirtualSwitch.getUuid());
                    distributedVirtualSwitchPortConnection.setPortgroupKey(distributedVirtualPortgroup.getKey());
                    distributedVirtualSwitchPortConnection.setPortKey(expandedDistributedPortId);
                    virtualEthernetCardDistributedVirtualPortBackingInfo.setPort(distributedVirtualSwitchPortConnection);
                    VSphereLogger.vsLogger(jLogger, "Distributed Switch Port Group -> " + expandedDistributedPortGroup + "Port Id -> " + expandedDistributedPortId + " successfully configured!");
                } else {
                    VSphereLogger.vsLogger(jLogger, "Failed to find Distributed Virtual Portgroup for Port Group -> " + expandedDistributedPortGroup);
                }
            } else {
                VSphereLogger.vsLogger(jLogger, "Network Device -> " + expandedDeviceLabel + " isn't distributed switch");
            }
        }
        VirtualDeviceConfigSpec vdspec = new VirtualDeviceConfigSpec();
        vdspec.setDevice((VirtualDevice)vEth);
        if (this.deviceAction == ReconfigureStep.DeviceAction.EDIT) {
            vdspec.setOperation(VirtualDeviceConfigSpecOperation.edit);
        } else if (this.deviceAction == ReconfigureStep.DeviceAction.REMOVE) {
            vdspec.setOperation(VirtualDeviceConfigSpecOperation.remove);
        }
        VirtualDeviceConfigSpec[] deviceConfigSpecs = this.spec.getDeviceChange();
        deviceConfigSpecs = deviceConfigSpecs == null ? new VirtualDeviceConfigSpec[1] : Arrays.copyOf(deviceConfigSpecs, deviceConfigSpecs.length + 1);
        deviceConfigSpecs[deviceConfigSpecs.length - 1] = vdspec;
        this.spec.setDeviceChange(deviceConfigSpecs);
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    private VirtualEthernetCard findNetworkDeviceByLabel(VirtualDevice[] devices, String label) {
        for (VirtualDevice vd : devices) {
            if (!(vd instanceof VirtualEthernetCard) || !label.isEmpty() && !vd.getDeviceInfo().getLabel().contentEquals(label)) continue;
            return (VirtualEthernetCard)vd;
        }
        return null;
    }

    @Extension
    public static final class ReconfigureNetworkAdaptersDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureNetworkAdaptersDescriptor() {
            this.load();
        }

        public FormValidation doCheckMacAddress(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the MAC Address"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureNetworkAdapter();
        }

        public FormValidation doTestData(@QueryParameter ReconfigureStep.DeviceAction deviceAction, @QueryParameter String deviceLabel, @QueryParameter String macAddress, @QueryParameter boolean standardSwitch, @QueryParameter String portGroup, @QueryParameter boolean distributedSwitch, @QueryParameter String distributedPortGroup, @QueryParameter String distributedPortId) {
            try {
                if (standardSwitch && distributedSwitch) {
                    return FormValidation.error((String)Messages.validation_wrongSwitchSelection());
                }
                return this.doCheckMacAddress(macAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

