/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReconfigureMemory
extends ReconfigureStep {
    private final String memorySize;

    @DataBoundConstructor
    public ReconfigureMemory(String memorySize) throws VSphereException {
        this.memorySize = memorySize;
    }

    public String getMemorySize() {
        return this.memorySize;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.reconfigureMemory(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.reconfigureMemory((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public boolean reconfigureMemory(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedMemorySize = this.memorySize;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedMemorySize = env.expand(this.memorySize);
        }
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: Memory");
        this.spec.setMemoryMB(Long.valueOf(expandedMemorySize));
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Extension
    public static final class ReconfigureMemoryDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureMemoryDescriptor() {
            this.load();
        }

        public FormValidation doCheckMemorySize(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Memory Size"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureMemory();
        }

        public FormValidation doTestData(@QueryParameter String memorySize) {
            try {
                return this.doCheckMemorySize(memorySize);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

