/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class PowerOn
extends VSphereBuildStep {
    private final String vm;
    private final int timeoutInSeconds;
    private String IP;

    @DataBoundConstructor
    public PowerOn(String vm, int timeoutInSeconds) throws VSphereException {
        this.vm = vm;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public String getVm() {
        return this.vm;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @Override
    public String getIP() {
        return this.IP;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.powerOn(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.powerOn((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private boolean powerOn(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException, IOException, InterruptedException {
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        EnvVars env = run.getEnvironment(listener);
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
        }
        long startTimeNanos = System.nanoTime();
        this.vsphere.startVm(expandedVm, this.timeoutInSeconds);
        long elapsedTime = TimeUnit.SECONDS.convert(System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
        int secondsToWaitForIp = (int)((long)this.timeoutInSeconds - elapsedTime);
        this.IP = this.vsphere.getIp(this.vsphere.getVmByName(expandedVm), secondsToWaitForIp);
        if (this.IP == null) {
            VSphereLogger.vsLogger(jLogger, "Error: Timed out after waiting " + secondsToWaitForIp + " seconds to get IP for \"" + expandedVm + "\" ");
            return false;
        }
        VSphereLogger.vsLogger(jLogger, "Successfully retrieved IP for \"" + expandedVm + "\" : " + this.IP);
        VSphereLogger.vsLogger(jLogger, "Exposing " + this.IP + " as environment variable VSPHERE_IP");
        if (run instanceof AbstractBuild) {
            VSphereEnvAction envAction = new VSphereEnvAction();
            envAction.add("VSPHERE_IP", this.IP);
            run.addAction((Action)envAction);
        } else {
            env.put("VSPHERE_IP", this.IP);
        }
        return true;
    }

    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private final transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static class PowerOnDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_PowerOn();
        }

        public FormValidation doCheckTimeoutInSeconds(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Timeout"));
            }
            if (!value.matches("\\d+")) {
                return FormValidation.error((String)Messages.validation_positiveInteger("Timeout"));
            }
            if (Integer.parseInt(value) > 3600) {
                return FormValidation.error((String)Messages.validation_maxValue(3600));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (vm.length() == 0 || serverName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = PowerOnDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

