/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.mo.VirtualMachine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ExposeGuestInfo
extends VSphereBuildStep
implements SimpleBuildStep {
    private static final List USABLE_CLASS_TYPES = Arrays.asList(String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class);
    private static final Pattern ipv4Pattern = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$");
    private final String vm;
    private final String envVariablePrefix;
    private final Boolean waitForIp4;
    private String resolvedEnvVariablePrefix = null;
    private String IP;
    private final Map<String, String> envVars = new HashMap<String, String>();

    @DataBoundConstructor
    public ExposeGuestInfo(String vm, String envVariablePrefix, Boolean waitForIp4) throws VSphereException {
        this.vm = vm;
        this.envVariablePrefix = envVariablePrefix;
        this.waitForIp4 = waitForIp4;
    }

    public String getVm() {
        return this.vm;
    }

    public String getEnvVariablePrefix() {
        return this.envVariablePrefix;
    }

    @Override
    public String getIP() {
        return this.IP;
    }

    public Map<String, String> getVars() {
        return this.envVars;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.exposeInfo(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.exposeInfo((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    public boolean exposeInfo(Run<?, ?> run, Launcher launcher, TaskListener listener) throws Exception {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String vmName = this.vm;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            vmName = env.expand(this.vm);
            this.resolvedEnvVariablePrefix = env.expand(this.envVariablePrefix).replace("-", "_");
        }
        VSphereLogger.vsLogger(jLogger, "Exposing guest info for VM \"" + vmName + "\" as environment variables");
        VirtualMachine vsphereVm = this.vsphere.getVmByName(vmName);
        if (vsphereVm == null) {
            throw new RuntimeException(Messages.validation_notFound("vm " + vmName));
        }
        VSphereEnvAction envAction = this.createGuestInfoEnvAction(vsphereVm, jLogger);
        if (this.waitForIp4.booleanValue()) {
            String prefix = this.resolvedEnvVariablePrefix == null ? this.envVariablePrefix : this.resolvedEnvVariablePrefix;
            String machineIP = (String)envAction.data.get(prefix + "_IpAddress");
            while (!ipv4Pattern.matcher(machineIP).find()) {
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                envAction = this.createGuestInfoEnvAction(this.vsphere.getVmByName(vmName), jLogger);
                machineIP = (String)envAction.data.get(prefix + "_IpAddress");
            }
        }
        run.addAction((Action)envAction);
        VSphereLogger.vsLogger(jLogger, "Successfully exposed guest info for VM \"" + vmName + "\"");
        return true;
    }

    private VSphereEnvAction createGuestInfoEnvAction(VirtualMachine vsphereVm, PrintStream jLogger) throws InvocationTargetException, IllegalAccessException {
        GuestInfo guestInfo = vsphereVm.getGuest();
        VSphereEnvAction envAction = new VSphereEnvAction();
        String prefix = this.resolvedEnvVariablePrefix == null ? this.envVariablePrefix : this.resolvedEnvVariablePrefix;
        for (Method method : GuestInfo.class.getDeclaredMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length > 0) continue;
            String variableName = method.getName().substring(3);
            Class<?> returnType = method.getReturnType();
            if (!USABLE_CLASS_TYPES.contains(returnType) && !returnType.isEnum()) {
                VSphereLogger.vsLogger(jLogger, "Skipped \"" + variableName + "\" as it is of type " + returnType.toString());
                continue;
            }
            Object value = method.invoke((Object)guestInfo, new Object[0]);
            if (value == null) {
                VSphereLogger.vsLogger(jLogger, "Skipped \"" + variableName + "\" as it is a null value");
                continue;
            }
            if ("IpAddress".equals(variableName)) {
                this.IP = String.valueOf(value);
            }
            this.envVars.put(prefix + "_" + variableName, String.valueOf(value));
            String environmentVariableName = prefix + "_" + variableName;
            String environmentVariableValue = String.valueOf(value);
            envAction.add(environmentVariableName, environmentVariableValue);
            VSphereLogger.vsLogger(jLogger, "Added environmental variable \"" + environmentVariableName + "\" with a value of \"" + environmentVariableValue + "\"");
        }
        return envAction;
    }

    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static class ExposeGuestInfoDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_ExposeGuestInfo();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvVariablePrefix(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the environment variable prefix"));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (vm.length() == 0 || serverName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = ExposeGuestInfoDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

