/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ConvertToVm
extends VSphereBuildStep {
    private final String template;
    private final String resourcePool;
    private final String cluster;

    @DataBoundConstructor
    public ConvertToVm(String template, String resourcePool, String cluster) throws VSphereException {
        this.template = template;
        this.resourcePool = resourcePool;
        this.cluster = cluster;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.convert(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.convert((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private boolean convert(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Converting template to VM. Please wait ...");
        String expandedTemplate = this.template;
        String expandedCluster = this.cluster;
        String expandedResourcePool = this.resourcePool;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedTemplate = env.expand(this.template);
            expandedCluster = env.expand(this.cluster);
            expandedResourcePool = env.expand(this.resourcePool);
        }
        this.vsphere.markAsVm(expandedTemplate, expandedResourcePool, expandedCluster);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedTemplate + "\" is a VM!");
        return true;
    }

    @Extension
    public static final class ConvertToVmDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public ConvertToVmDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_ConvertToVM();
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the Template name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the resource pool"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String template, @QueryParameter String resourcePool, @QueryParameter String cluster) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (serverName.length() == 0 || template.length() == 0 || resourcePool.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (template.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("Template"));
                }
                VSphere vsphere = ConvertToVmDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("template"));
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_alreadySet("template", "VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

