/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class VSphereConnectionConfig
extends AbstractDescribableImpl<VSphereConnectionConfig> {
    @CheckForNull
    private final String vsHost;
    private boolean allowUntrustedCertificate;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public VSphereConnectionConfig(String vsHost, String credentialsId) {
        this.vsHost = vsHost;
        this.credentialsId = credentialsId;
    }

    public VSphereConnectionConfig(String vsHost, boolean allowUntrustedCertificate, String credentialsId) {
        this(vsHost, credentialsId);
        this.setAllowUntrustedCertificate(allowUntrustedCertificate);
    }

    @CheckForNull
    public String getVsHost() {
        return this.vsHost;
    }

    @DataBoundSetter
    public void setAllowUntrustedCertificate(boolean allowUntrustedCertificate) {
        this.allowUntrustedCertificate = allowUntrustedCertificate;
    }

    public boolean getAllowUntrustedCertificate() {
        return this.allowUntrustedCertificate;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public StandardCredentials getCredentials() {
        return DescriptorImpl.lookupCredentials(this.credentialsId, this.vsHost);
    }

    @CheckForNull
    public String getPassword() {
        StandardCredentials credentials = this.getCredentials();
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            Secret password = ((StandardUsernamePasswordCredentials)credentials).getPassword();
            return Secret.toString((Secret)password);
        }
        return null;
    }

    @CheckForNull
    public String getUsername() {
        StandardCredentials credentials = this.getCredentials();
        if (credentials instanceof StandardUsernameCredentials) {
            return ((StandardUsernameCredentials)credentials).getUsername();
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<VSphereConnectionConfig> {
        private static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});

        public String getDisplayName() {
            return "N/A";
        }

        public FormValidation doCheckVsHost(@QueryParameter String value) {
            if (value != null && value.length() != 0) {
                if (!value.startsWith("https://")) {
                    return FormValidation.error((String)"vSphere host must start with https://");
                }
                if (value.endsWith("/")) {
                    return FormValidation.error((String)"vSphere host name must NOT end with a trailing slash");
                }
            }
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckAllowUntrustedCertificate(@QueryParameter boolean value) {
            if (value) {
                return FormValidation.warning((String)"Warning: This is not secure.");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath AbstractFolder<?> containingFolderOrNull, @QueryParameter String vsHost) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureCloud(containingFolderOrNull);
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardCredentials.class, Collections.singletonList(DescriptorImpl.getDomainRequirement(vsHost)), CREDENTIALS_MATCHER);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath AbstractFolder<?> containingFolderOrNull, @QueryParameter String vsHost, @QueryParameter String value) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureCloud(containingFolderOrNull);
            value = Util.fixEmptyAndTrim((String)value);
            if (value == null) {
                return FormValidation.ok();
            }
            if ((vsHost = Util.fixEmptyAndTrim((String)vsHost)) == null) {
                return FormValidation.warning((String)"Cannot validate credentials. Host is not set");
            }
            StandardCredentials credentials = DescriptorImpl.lookupCredentials(value, vsHost);
            if (credentials == null) {
                return FormValidation.warning((String)("Cannot find any credentials with id " + value));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doTestConnection(@AncestorInPath AbstractFolder<?> containingFolderOrNull, @QueryParameter String vsHost, @QueryParameter boolean allowUntrustedCertificate, @QueryParameter String credentialsId) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureCloud(containingFolderOrNull);
            try {
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, allowUntrustedCertificate, credentialsId);
                String effectiveUsername = config.getUsername();
                String effectivePassword = config.getPassword();
                if (StringUtils.isEmpty((String)effectiveUsername)) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (effectivePassword == null) {
                    return FormValidation.error((String)"Password is not specified");
                }
                VSphere.connect(config).disconnect();
                return FormValidation.ok((String)"Connected successfully");
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Failed to connect");
            }
        }

        @NonNull
        private static DomainRequirement getDomainRequirement(String hostname) {
            return new HostnameRequirement(hostname);
        }

        @CheckForNull
        public static StandardCredentials lookupCredentials(@CheckForNull String credentialsId, @NonNull String vsHost) {
            Jenkins instance = Jenkins.getInstance();
            if (instance != null && credentialsId != null) {
                return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)instance, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{DescriptorImpl.getDomainRequirement(vsHost)}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            }
            return null;
        }
    }
}

