/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;

public abstract class VSphereBuildStep
implements Describable<VSphereBuildStep>,
ExtensionPoint {
    protected VSphere vsphere;
    private static boolean ALLOW_VM_DELETE = true;

    public VSphere getVsphere() {
        return this.vsphere;
    }

    public void setVsphere(VSphere vsphere) {
        this.vsphere = vsphere;
    }

    public String getIP() {
        return "";
    }

    public static DescriptorExtensionList<VSphereBuildStep, VSphereBuildStepDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(VSphereBuildStep.class);
    }

    public abstract boolean perform(AbstractBuild<?, ?> var1, Launcher var2, BuildListener var3) throws Exception;

    public abstract void perform(@NonNull Run<?, ?> var1, @NonNull FilePath var2, @NonNull Launcher var3, @NonNull TaskListener var4) throws InterruptedException, IOException;

    public VSphereBuildStepDescriptor getDescriptor() {
        return (VSphereBuildStepDescriptor)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public static boolean allowDelete() {
        return ALLOW_VM_DELETE;
    }

    public static abstract class VSphereBuildStepDescriptor
    extends Descriptor<VSphereBuildStep> {
        protected VSphereBuildStepDescriptor() {
        }

        protected VSphereBuildStepDescriptor(Class<? extends VSphereBuildStep> clazz) {
            super(clazz);
        }

        public static vSphereCloud getVSphereCloudByName(String serverName) throws RuntimeException, VSphereException {
            return VSphereBuildStepDescriptor.getVSphereCloudByName(serverName, null);
        }

        public static vSphereCloud getVSphereCloudByHash(int hash) throws RuntimeException, VSphereException {
            return VSphereBuildStepDescriptor.getVSphereCloudByHash(hash, null);
        }

        public static vSphereCloud getVSphereCloudByName(String serverName, String jobName) throws RuntimeException, VSphereException {
            if (serverName != null) {
                for (vSphereCloud cloud : vSphereCloud.findAllVsphereClouds(jobName)) {
                    if (!cloud.getVsDescription().equals(serverName)) continue;
                    return cloud;
                }
            }
            throw new RuntimeException(Messages.validation_instanceNotFound(serverName));
        }

        public static vSphereCloud getVSphereCloudByHash(int hash, String jobName) throws RuntimeException, VSphereException {
            for (vSphereCloud cloud : vSphereCloud.findAllVsphereClouds(jobName)) {
                if (cloud.getHash() != hash) continue;
                return cloud;
            }
            throw new RuntimeException(Messages.validation_serverExistence());
        }
    }
}

