/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplate;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningRecord;

public class CloudProvisioningState {
    private static final Logger LOGGER = Logger.getLogger(CloudProvisioningState.class.getName());
    private final Map<vSphereCloudSlaveTemplate, CloudProvisioningRecord> records = new IdentityHashMap<vSphereCloudSlaveTemplate, CloudProvisioningRecord>();
    private final vSphereCloud parent;
    private final transient Logger logger;

    public CloudProvisioningState(vSphereCloud parent) {
        this(parent, LOGGER);
    }

    CloudProvisioningState(vSphereCloud parent, Logger logger) {
        this.parent = parent;
        this.logger = logger;
        this.logger.log(Level.FINE, "Created for parent {0}", parent.toString());
    }

    public void provisioningStarted(CloudProvisioningRecord provisionable, String nodeName) {
        boolean wasPreviouslyUnknownToPlanning = provisionable.addCurrentlyPlanned(nodeName);
        boolean wasAlreadyActive = provisionable.removeCurrentlyActive(nodeName);
        boolean wasPreviouslyUnwanted = provisionable.removeCurrentlyUnwanted(nodeName);
        this.logStateChange(Level.FINE, "Intending to create {0}", "wasPreviouslyUnknownToPlanning", wasPreviouslyUnknownToPlanning, true, "wasAlreadyActive", wasAlreadyActive, false, "wasPreviouslyUnwanted", wasPreviouslyUnwanted, false, nodeName);
    }

    public void provisionedSlaveNowActive(CloudProvisioningRecord provisionable, String nodeName) {
        boolean wasNotPreviouslyActive = provisionable.addCurrentlyActive(nodeName);
        boolean wasPreviouslyPlanned = provisionable.removeCurrentlyPlanned(nodeName);
        boolean wasPreviouslyUnwanted = provisionable.removeCurrentlyUnwanted(nodeName);
        this.logStateChange(Level.FINE, "Marking {0} as active", "wasNotPreviouslyActive", wasNotPreviouslyActive, true, "wasPreviouslyPlanned", wasPreviouslyPlanned, true, "wasPreviouslyUnwanted", wasPreviouslyUnwanted, false, nodeName);
    }

    public void provisionedSlaveNowUnwanted(String nodeName, boolean willAttemptImmediateDeletion) {
        Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry = this.findEntryForVM(nodeName);
        if (entry != null) {
            CloudProvisioningRecord provisionable = entry.getValue();
            boolean wasPreviouslyPlanned = provisionable.removeCurrentlyPlanned(nodeName);
            boolean wasPreviouslyActive = provisionable.removeCurrentlyActive(nodeName);
            boolean wasNotPreviouslyUnwanted = provisionable.setCurrentlyUnwanted(nodeName, willAttemptImmediateDeletion) == null;
            this.logStateChange(Level.FINE, "Marking {0} for termination", "wasPreviouslyPlanned", wasPreviouslyPlanned, false, "wasPreviouslyActive", wasPreviouslyActive, true, "wasNotPreviouslyUnwanted", wasNotPreviouslyUnwanted, true, nodeName);
        } else {
            this.logger.log(Level.WARNING, "Asked to mark {0} for termination, but we have no record of it.", nodeName);
        }
    }

    public Boolean isOkToDeleteUnwantedVM(String nodeName) {
        boolean isOkForUsToDeleteIt;
        Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry = this.findEntryForVM(nodeName);
        if (entry == null) {
            return null;
        }
        CloudProvisioningRecord record = entry.getValue();
        Boolean thisNode = record.isCurrentlyUnwanted(nodeName);
        if (thisNode == null) {
            return null;
        }
        boolean someoneElseIsDeletingThis = thisNode;
        boolean bl = isOkForUsToDeleteIt = !someoneElseIsDeletingThis;
        if (isOkForUsToDeleteIt) {
            record.setCurrentlyUnwanted(nodeName, true);
        }
        return isOkForUsToDeleteIt;
    }

    public void unwantedSlaveNowDeleted(String nodeName) {
        Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry = this.findEntryForVM(nodeName);
        if (entry != null) {
            CloudProvisioningRecord provisionable = entry.getValue();
            boolean wasPreviouslyPlanned = provisionable.removeCurrentlyPlanned(nodeName);
            boolean wasPreviouslyActive = provisionable.removeCurrentlyActive(nodeName);
            boolean wasPreviouslyUnwanted = provisionable.removeCurrentlyUnwanted(nodeName);
            if (this.recordIsPrunable(provisionable)) {
                this.removeExistingRecord(provisionable);
            }
            this.logStateChange(Level.FINE, "Marking {0} as successfully terminated", "wasPreviouslyPlanned", wasPreviouslyPlanned, false, "wasPreviouslyActive", wasPreviouslyActive, false, "wasPreviouslyUnwanted", wasPreviouslyUnwanted, true, nodeName);
        } else {
            this.logger.log(Level.WARNING, "Asked to mark {0} as terminated, but we had no record of it.", nodeName);
        }
    }

    public void unwantedSlaveNotDeleted(String nodeName) {
        Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry = this.findEntryForVM(nodeName);
        if (entry != null) {
            CloudProvisioningRecord provisionable = entry.getValue();
            boolean isPlanned = provisionable.getCurrentlyPlanned().contains(nodeName);
            boolean isActive = provisionable.getCurrentlyProvisioned().contains(nodeName);
            boolean isUnwanted = provisionable.setCurrentlyUnwanted(nodeName, false) != null;
            this.logStateChange(Level.INFO, "Marking {0} as unsuccessfully terminated - we'll have to try again later", "isPlanned", isPlanned, false, "isActive", isActive, false, "isUnwanted", isUnwanted, true, nodeName);
        } else {
            this.logger.log(Level.WARNING, "Asked to mark {0} as unsuccessfully terminated, but we had no record of it.", nodeName);
        }
    }

    public void recordExistingUnwantedVM(vSphereCloudSlaveTemplate template, String nodeName) {
        CloudProvisioningRecord record = this.getOrCreateRecord(template);
        boolean wasPreviouslyPlanned = record.removeCurrentlyPlanned(nodeName);
        boolean wasPreviouslyActive = record.removeCurrentlyActive(nodeName);
        boolean wasAlreadyUnwanted = record.setCurrentlyUnwanted(nodeName, false) != null;
        this.logStateChange(Level.INFO, "Marking {0} as found in vSphere but unwanted", "wasPreviouslyPlanned", wasPreviouslyPlanned, false, "wasPreviouslyActive", wasPreviouslyActive, false, "wasAlreadyUnwanted", wasAlreadyUnwanted, false, nodeName);
    }

    public void provisioningEndedInError(CloudProvisioningRecord provisionable, String nodeName) {
        boolean wasPreviouslyPlanned = provisionable.removeCurrentlyPlanned(nodeName);
        boolean wasPreviouslyActive = provisionable.removeCurrentlyActive(nodeName);
        boolean wasPreviouslyUnwanted = provisionable.removeCurrentlyUnwanted(nodeName);
        if (this.recordIsPrunable(provisionable)) {
            this.removeExistingRecord(provisionable);
        }
        this.logStateChange(Level.INFO, "Marking {0} as failed", "wasPreviouslyPlanned", wasPreviouslyPlanned, true, "wasPreviouslyActive", wasPreviouslyActive, false, "wasPreviouslyUnwanted", wasPreviouslyUnwanted, false, nodeName);
    }

    public void pruneUnwantedRecords() {
        ArrayList<CloudProvisioningRecord> toBeRemoved = new ArrayList<CloudProvisioningRecord>(this.records.size());
        for (Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry : this.records.entrySet()) {
            CloudProvisioningRecord record = entry.getValue();
            if (!this.recordIsPrunable(record)) continue;
            toBeRemoved.add(record);
        }
        for (CloudProvisioningRecord record : toBeRemoved) {
            this.removeExistingRecord(record);
        }
    }

    public List<CloudProvisioningRecord> calculateProvisionableTemplates(Iterable<vSphereCloudSlaveTemplate> templates) {
        ArrayList<CloudProvisioningRecord> result = new ArrayList<CloudProvisioningRecord>();
        for (vSphereCloudSlaveTemplate template : templates) {
            CloudProvisioningRecord provisionable = this.getOrCreateRecord(template);
            result.add(provisionable);
        }
        return result;
    }

    public int countNodes() {
        int result = 0;
        for (CloudProvisioningRecord record : this.records.values()) {
            result += record.size();
        }
        return result;
    }

    public CloudProvisioningRecord getOrCreateRecord(vSphereCloudSlaveTemplate template) {
        CloudProvisioningRecord existingRecord = this.getExistingRecord(template);
        if (existingRecord != null) {
            return existingRecord;
        }
        CloudProvisioningRecord newRecord = new CloudProvisioningRecord(template);
        this.logger.log(Level.FINE, "Creating new record for template {0} ({1})", new Object[]{template.getCloneNamePrefix(), template.toString()});
        this.records.put(template, newRecord);
        return newRecord;
    }

    public List<String> getUnwantedVMsThatNeedDeleting() {
        int count = 0;
        LinkedHashMap allUnwantedVmsByRecord = new LinkedHashMap();
        for (CloudProvisioningRecord record : this.records.values()) {
            Map<String, Boolean> currentlyUnwanted = record.getCurrentlyUnwanted();
            ArrayList<String> vmsInNeedOfDeletionForThisRecord = new ArrayList<String>(currentlyUnwanted.size());
            for (Map.Entry<String, Boolean> entry : currentlyUnwanted.entrySet()) {
                if (entry.getValue() != Boolean.FALSE) continue;
                vmsInNeedOfDeletionForThisRecord.add(entry.getKey());
            }
            count += vmsInNeedOfDeletionForThisRecord.size();
            allUnwantedVmsByRecord.put(record, vmsInNeedOfDeletionForThisRecord.iterator());
        }
        ArrayList<String> vmsInNeedOfDeletion = new ArrayList<String>(count);
        while (vmsInNeedOfDeletion.size() < count) {
            for (Iterator i : allUnwantedVmsByRecord.values()) {
                if (!i.hasNext()) continue;
                String nodeName = (String)i.next();
                vmsInNeedOfDeletion.add(nodeName);
            }
        }
        return vmsInNeedOfDeletion;
    }

    private CloudProvisioningRecord getExistingRecord(vSphereCloudSlaveTemplate template) {
        return this.records.get(template);
    }

    private void removeExistingRecord(CloudProvisioningRecord existingRecord) {
        vSphereCloudSlaveTemplate template = existingRecord.getTemplate();
        this.logger.log(Level.FINE, "Disposing of record for template {0} ({1})", new Object[]{template.getCloneNamePrefix(), template.toString()});
        this.records.remove(template);
    }

    private boolean recordIsPrunable(CloudProvisioningRecord record) {
        boolean isEmpty = record.isEmpty();
        if (!isEmpty) {
            return false;
        }
        vSphereCloudSlaveTemplate template = record.getTemplate();
        List<? extends vSphereCloudSlaveTemplate> knownTemplates = this.parent.getTemplates();
        boolean isKnownToParent = knownTemplates.contains(template);
        return !isKnownToParent;
    }

    private Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> findEntryForVM(String nodeName) {
        for (Map.Entry<vSphereCloudSlaveTemplate, CloudProvisioningRecord> entry : this.records.entrySet()) {
            CloudProvisioningRecord record = entry.getValue();
            if (!record.contains(nodeName)) continue;
            return entry;
        }
        return null;
    }

    private void logStateChange(Level logLevel, String logMsg, String firstArgName, boolean actualFirstArgValue, boolean expectedFirstArgValue, String secondArgName, boolean actualSecondArgValue, boolean expectedSecondArgValue, String thirdArgName, boolean actualThirdArgValue, boolean expectedThirdArgValue, Object ... args) {
        boolean firstValid = actualFirstArgValue == expectedFirstArgValue;
        boolean secondValid = actualSecondArgValue == expectedSecondArgValue;
        boolean thirdValid = actualThirdArgValue == expectedThirdArgValue;
        Level actualLevel = logLevel;
        String actualMsg = logMsg;
        if (!firstValid) {
            actualMsg = actualMsg + " : " + firstArgName + "!=" + expectedFirstArgValue;
            actualLevel = Level.WARNING;
        }
        if (!secondValid) {
            actualMsg = actualMsg + " : " + secondArgName + "!=" + expectedSecondArgValue;
            actualLevel = Level.WARNING;
        }
        if (!thirdValid) {
            actualMsg = actualMsg + " : " + thirdArgName + "!=" + expectedThirdArgValue;
            actualLevel = Level.WARNING;
        }
        Logger loggerToUse = this.logger != null ? this.logger : LOGGER;
        loggerToUse.log(actualLevel, actualMsg, args);
    }
}

