/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.kohsuke.stapler.DataBoundConstructor;

public class vSphereCloudProvisionedSlave
extends vSphereCloudSlave {
    @DataBoundConstructor
    public vSphereCloudProvisionedSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, delegateLauncher, retentionStrategy, nodeProperties, vsDescription, vmName, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption, LimitedTestRunCount);
    }

    @Override
    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        super._terminate(listener);
        try {
            ComputerLauncher l = this.getLauncher();
            vSphereCloud cloud = this.findOurVsInstance(l);
            if (cloud != null) {
                String cloneName = this.getComputer().getName();
                cloud.provisionedSlaveHasTerminated(cloneName);
            } else {
                vSphereCloud.Log(listener, "%1s._terminate for vmName %2s failed as getLauncher() returned %3s", ((Object)((Object)this)).getClass().getSimpleName(), this.getVmName(), l);
            }
        }
        catch (RuntimeException ex) {
            vSphereCloud.Log(listener, (Throwable)ex, "%1s._terminate for vmName %2s failed", ((Object)((Object)this)).getClass().getSimpleName(), this.getVmName());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends vSphereCloudSlave.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return super.getDisplayName() + ", auto-provisioned by Jenkins from cloud template";
        }

        public boolean isInstantiable() {
            return false;
        }
    }

    @Extension
    public static class vSphereCloudComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof vSphereCloudProvisionedSlave)) {
                return;
            }
            vSphereCloudLauncher vsL = (vSphereCloudLauncher)((SlaveComputer)c).getLauncher();
            vSphereCloud vsC = vsL.findOurVsInstance();
            if (!vsC.markVMOnline(c.getDisplayName(), vsL.getVmName()).booleanValue()) {
                throw new AbortException("The vSphere cloud will not allow this slave to start at this time.");
            }
        }
    }
}

