/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplate;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningRecord;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class CloudProvisioningAlgorithm {
    private CloudProvisioningAlgorithm() {
    }

    public static CloudProvisioningRecord findTemplateWithMostFreeCapacity(Collection<? extends CloudProvisioningRecord> provisionables) {
        CloudProvisioningRecord bestOption;
        TreeSet<CloudProvisioningRecord> sortedSet = new TreeSet<CloudProvisioningRecord>(CloudProvisioningRecord.leastUsedFirst);
        sortedSet.addAll(provisionables);
        Iterator iterator = sortedSet.iterator();
        if (iterator.hasNext() && (bestOption = (CloudProvisioningRecord)iterator.next()).hasCapacityForMore()) {
            return bestOption;
        }
        return null;
    }

    public static String findUnusedName(CloudProvisioningRecord record) {
        vSphereCloudSlaveTemplate template = record.getTemplate();
        String cloneNamePrefix = template.getCloneNamePrefix();
        Set<String> existingNames = record.getCurrentNames();
        int templateInstanceCap = template.getTemplateInstanceCap();
        boolean hasCap = templateInstanceCap > 0 && templateInstanceCap < Integer.MAX_VALUE;
        int maxAttempts = hasCap ? templateInstanceCap : 100;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            String suffix = hasCap ? CloudProvisioningAlgorithm.calcSequentialSuffix(attempt) : CloudProvisioningAlgorithm.calcRandomSuffix(attempt);
            String nodeName = cloneNamePrefix + suffix;
            if (existingNames.contains(nodeName)) continue;
            return nodeName;
        }
        throw new IllegalStateException("Unable to find unused name for slave for record " + record.toString() + ", even after " + maxAttempts + " attempts.");
    }

    private static String calcSequentialSuffix(int attempt) {
        int slaveNumber = attempt + 1;
        String suffix = Integer.toString(slaveNumber);
        return suffix;
    }

    private static String calcRandomSuffix(int attempt) {
        UUID uuid = UUID.randomUUID();
        long lsb = uuid.getLeastSignificantBits();
        long msb = uuid.getMostSignificantBits();
        BigInteger bigNumber = CloudProvisioningAlgorithm.toBigInteger(msb, lsb);
        String suffix = bigNumber.toString(36);
        return suffix;
    }

    @Restricted(value={NoExternalUse.class})
    static BigInteger toBigInteger(long msb, long lsb) {
        byte[] bytes = new byte[17];
        int b = 0;
        bytes[b++] = 0;
        bytes[b++] = (byte)(msb >> 56);
        bytes[b++] = (byte)(msb >> 48);
        bytes[b++] = (byte)(msb >> 40);
        bytes[b++] = (byte)(msb >> 32);
        bytes[b++] = (byte)(msb >> 24);
        bytes[b++] = (byte)(msb >> 16);
        bytes[b++] = (byte)(msb >> 8);
        bytes[b++] = (byte)msb;
        bytes[b++] = (byte)(lsb >> 56);
        bytes[b++] = (byte)(lsb >> 48);
        bytes[b++] = (byte)(lsb >> 40);
        bytes[b++] = (byte)(lsb >> 32);
        bytes[b++] = (byte)(lsb >> 24);
        bytes[b++] = (byte)(lsb >> 16);
        bytes[b++] = (byte)(lsb >> 8);
        bytes[b++] = (byte)lsb;
        BigInteger bigNumber = new BigInteger(bytes);
        return bigNumber;
    }
}

