/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSphereConnectionConfig
extends AbstractDescribableImpl<VSphereConnectionConfig> {
    @CheckForNull
    private final String vsHost;
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public VSphereConnectionConfig(String vsHost, String credentialsId) {
        this.vsHost = vsHost;
        this.credentialsId = credentialsId;
    }

    @CheckForNull
    public String getVsHost() {
        return this.vsHost;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public StandardCredentials getCredentials() {
        return DescriptorImpl.lookupCredentials(this.credentialsId, this.vsHost);
    }

    @CheckForNull
    public String getPassword() {
        StandardCredentials credentials = this.getCredentials();
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            Secret password = ((StandardUsernamePasswordCredentials)credentials).getPassword();
            return Secret.toString((Secret)password);
        }
        return null;
    }

    @CheckForNull
    public String getUsername() {
        StandardCredentials credentials = this.getCredentials();
        if (credentials instanceof StandardUsernameCredentials) {
            return ((StandardUsernameCredentials)credentials).getUsername();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<VSphereConnectionConfig> {
        private static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});

        public String getDisplayName() {
            return "N/A";
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String vsHost) {
            Jenkins instance = Jenkins.getInstance();
            if (instance != null && instance.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().withEmptySelection().withMatching(CREDENTIALS_MATCHER, (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)instance, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{DescriptorImpl.getDomainRequirement(vsHost)}));
            }
            return new StandardListBoxModel();
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String vsHost, @QueryParameter String value) {
            Jenkins instance = Jenkins.getInstance();
            if (instance == null || !instance.hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            value = Util.fixEmptyAndTrim((String)value);
            if (value == null) {
                return FormValidation.ok();
            }
            if ((vsHost = Util.fixEmptyAndTrim((String)vsHost)) == null) {
                return FormValidation.warning((String)"Cannot validate credentials. Host is not set");
            }
            StandardCredentials credentials = DescriptorImpl.lookupCredentials(value, vsHost);
            if (credentials == null) {
                return FormValidation.warning((String)("Cannot find any credentials with id " + value));
            }
            return FormValidation.ok();
        }

        @Nonnull
        private static DomainRequirement getDomainRequirement(String hostname) {
            return new HostnameRequirement(hostname);
        }

        @CheckForNull
        public static StandardCredentials lookupCredentials(@CheckForNull String credentialsId, @Nonnull String vsHost) {
            Jenkins instance = Jenkins.getInstance();
            if (instance != null && credentialsId != null) {
                return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)instance, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{DescriptorImpl.getDomainRequirement(vsHost)}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            }
            return null;
        }
    }
}

