/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Delete
extends VSphereBuildStep {
    private final String vm;
    private final boolean failOnNoExist;

    @DataBoundConstructor
    public Delete(String vm, boolean failOnNoExist) throws VSphereException {
        this.failOnNoExist = failOnNoExist;
        this.vm = vm;
    }

    public String getVm() {
        return this.vm;
    }

    public boolean isFailOnNoExist() {
        return this.failOnNoExist;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            if (Delete.allowDelete()) {
                this.killVm(run, launcher, listener);
            } else {
                VSphereLogger.vsLogger(listener.getLogger(), "Deletion is disabled!");
            }
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            if (Delete.allowDelete()) {
                retVal = this.killVm((Run<?, ?>)build, launcher, (TaskListener)listener);
            } else {
                VSphereLogger.vsLogger(listener.getLogger(), "Deletion is disabled!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private boolean killVm(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
        }
        VSphereLogger.vsLogger(jLogger, "Destroying VM \"" + expandedVm + ".\" Please wait ...");
        this.vsphere.destroyVm(expandedVm, this.failOnNoExist);
        VSphereLogger.vsLogger(jLogger, "Destroyed!");
        return true;
    }

    @Extension
    public static final class DeleteDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public DeleteDescriptor() {
            this.load();
        }

        public FormValidation doCheckVm(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_Delete();
        }

        @RequirePOST
        public FormValidation doTestData(@AncestorInPath Item context, @QueryParameter String serverName, @QueryParameter String vm) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = DeleteDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

