/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplate;

public final class CloudProvisioningRecord {
    private final vSphereCloudSlaveTemplate template;
    private final Set<String> currentlyProvisioned;
    private final Set<String> currentlyPlanned;
    private final Map<String, Boolean> currentlyUnwanted;
    static final Comparator<CloudProvisioningRecord> leastUsedFirst = new Comparator<CloudProvisioningRecord>(){
        private static final int theyAreTheSame = 0;
        private static final int bShouldComeLast = -1;
        private static final int aShouldComeLast = 1;

        @Override
        public int compare(CloudProvisioningRecord a, CloudProvisioningRecord b) {
            if (b == a) {
                return 0;
            }
            int compareByCapacity = a.hasFiniteCapacity() && b.hasFiniteCapacity() ? this.compareByUsageRatio(a, b) : this.compareByUsage(a, b);
            if (compareByCapacity != 0) {
                return compareByCapacity;
            }
            int compareByMaxCapacity = this.compareByMaxCapacity(a, b);
            if (compareByMaxCapacity != 0) {
                return compareByMaxCapacity;
            }
            return this.tieBreak(a, b);
        }

        private int compareByUsageRatio(CloudProvisioningRecord a, CloudProvisioningRecord b) {
            double bFullness;
            double aFullness = a.calcFullness();
            if (aFullness > (bFullness = b.calcFullness())) {
                return 1;
            }
            if (aFullness < bFullness) {
                return -1;
            }
            return 0;
        }

        private int compareByUsage(CloudProvisioningRecord a, CloudProvisioningRecord b) {
            double bUsage;
            boolean bFull;
            boolean aFull = !a.hasCapacityForMore();
            boolean bl = bFull = !b.hasCapacityForMore();
            if (aFull != bFull) {
                if (aFull) {
                    return 1;
                }
                return -1;
            }
            double aUsage = a.calcCurrentCommitment();
            if (aUsage > (bUsage = (double)b.calcCurrentCommitment())) {
                return 1;
            }
            if (aUsage < bUsage) {
                return -1;
            }
            return 0;
        }

        private int compareByMaxCapacity(CloudProvisioningRecord a, CloudProvisioningRecord b) {
            int aCapacity = a.calcMaxToProvision();
            int bCapacity = b.calcMaxToProvision();
            if (bCapacity > aCapacity) {
                return 1;
            }
            if (bCapacity < aCapacity) {
                return -1;
            }
            return 0;
        }

        private int tieBreak(CloudProvisioningRecord a, CloudProvisioningRecord b) {
            int bCurrentlyPlanned;
            int aCurrentlyPlanned = a.currentlyPlanned.size();
            if (aCurrentlyPlanned > (bCurrentlyPlanned = b.currentlyPlanned.size())) {
                return 1;
            }
            if (aCurrentlyPlanned < bCurrentlyPlanned) {
                return -1;
            }
            return 0;
        }
    };

    CloudProvisioningRecord(vSphereCloudSlaveTemplate template) {
        this.template = template;
        this.currentlyProvisioned = new TreeSet<String>();
        this.currentlyPlanned = new TreeSet<String>();
        this.currentlyUnwanted = new LinkedHashMap<String, Boolean>();
    }

    public vSphereCloudSlaveTemplate getTemplate() {
        return this.template;
    }

    public String toString() {
        return String.format("Template[prefix=%s, provisioned=%s, planned=%s, unwanted=%s, max=%d, fullness=%.3f%%]", this.getTemplate().getCloneNamePrefix(), this.getCurrentlyProvisioned(), this.getCurrentlyPlanned(), this.getCurrentlyUnwanted(), this.calcMaxToProvision(), this.calcFullness() * 100.0);
    }

    Set<String> getCurrentlyProvisioned() {
        return this.currentlyProvisioned;
    }

    boolean addCurrentlyActive(String nodeName) {
        return this.currentlyProvisioned.add(nodeName);
    }

    boolean removeCurrentlyActive(String nodeName) {
        return this.currentlyProvisioned.remove(nodeName);
    }

    Set<String> getCurrentlyPlanned() {
        return this.currentlyPlanned;
    }

    boolean addCurrentlyPlanned(String nodeName) {
        return this.currentlyPlanned.add(nodeName);
    }

    boolean removeCurrentlyPlanned(String nodeName) {
        return this.currentlyPlanned.remove(nodeName);
    }

    Map<String, Boolean> getCurrentlyUnwanted() {
        return this.currentlyUnwanted;
    }

    Boolean isCurrentlyUnwanted(String nodeName) {
        return this.currentlyUnwanted.get(nodeName);
    }

    Boolean setCurrentlyUnwanted(String nodeName, boolean beingDeleted) {
        Boolean oldValue = this.currentlyUnwanted.remove(nodeName);
        this.currentlyUnwanted.put(nodeName, beingDeleted);
        return oldValue;
    }

    boolean removeCurrentlyUnwanted(String nodeName) {
        return this.currentlyUnwanted.remove(nodeName) != null;
    }

    Set<String> getCurrentNames() {
        TreeSet<String> existingNames = new TreeSet<String>();
        existingNames.addAll(this.getCurrentlyPlanned());
        existingNames.addAll(this.getCurrentlyProvisioned());
        existingNames.addAll(this.getCurrentlyUnwanted().keySet());
        return existingNames;
    }

    boolean contains(String nodeName) {
        return this.currentlyProvisioned.contains(nodeName) || this.currentlyPlanned.contains(nodeName) || this.currentlyUnwanted.containsKey(nodeName);
    }

    int size() {
        return this.currentlyProvisioned.size() + this.currentlyPlanned.size() + this.currentlyUnwanted.size();
    }

    boolean isEmpty() {
        return this.currentlyProvisioned.isEmpty() && this.currentlyPlanned.isEmpty() && this.currentlyUnwanted.isEmpty();
    }

    private int calcMaxToProvision() {
        int templateInstanceCap = this.template.getTemplateInstanceCap();
        int maxToProvision = templateInstanceCap == 0 ? Integer.MAX_VALUE : templateInstanceCap;
        return maxToProvision;
    }

    private boolean hasFiniteCapacity() {
        int templateInstanceCap = this.template.getTemplateInstanceCap();
        int maxToProvision = templateInstanceCap == 0 ? Integer.MAX_VALUE : templateInstanceCap;
        return maxToProvision != Integer.MAX_VALUE;
    }

    private double calcFullness() {
        int maxToProvision = this.calcMaxToProvision();
        return (double)this.calcCurrentCommitment() / (double)maxToProvision;
    }

    boolean hasCapacityForMore() {
        int totalCommitment = this.calcCurrentCommitment();
        int maxToProvision = this.calcMaxToProvision();
        return maxToProvision > totalCommitment;
    }

    private int calcCurrentCommitment() {
        return this.currentlyProvisioned.size() + this.currentlyPlanned.size() + this.currentlyUnwanted.size();
    }
}

