/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReconfigureCpu
extends ReconfigureStep {
    private final String cpuCores;
    private final String coresPerSocket;

    @DataBoundConstructor
    public ReconfigureCpu(String cpuCores, String coresPerSocket) throws VSphereException {
        this.cpuCores = cpuCores;
        this.coresPerSocket = coresPerSocket;
    }

    public String getCpuCores() {
        return this.cpuCores;
    }

    public String getCoresPerSocket() {
        return this.coresPerSocket;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.reconfigureCPU(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.reconfigureCPU((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public boolean reconfigureCPU(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedCPUCores = this.cpuCores;
        String expandedCoresPerSocket = this.coresPerSocket;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedCPUCores = env.expand(this.cpuCores);
            expandedCoresPerSocket = env.expand(this.coresPerSocket);
        }
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: CPU");
        this.spec.setNumCPUs(Integer.valueOf(expandedCPUCores));
        this.spec.setNumCoresPerSocket(Integer.valueOf(expandedCoresPerSocket));
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Extension
    public static final class ReconfigureCpuDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureCpuDescriptor() {
            this.load();
        }

        public FormValidation doCheckCpuCores(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("CPU Cores"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCoresPerSocket(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Cores per socket"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureCpu();
        }

        public FormValidation doTestData(@QueryParameter String cpuCores, @QueryParameter String coresPerSocket) {
            try {
                if (Integer.valueOf(coresPerSocket) > Integer.valueOf(cpuCores)) {
                    return FormValidation.error((String)Messages.validation_maxValue(Integer.valueOf(cpuCores) + 1));
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

