/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Clone
extends VSphereBuildStep {
    private static final int TIMEOUT_DEFAULT = 60;
    private final String sourceName;
    private final String clone;
    private final boolean linkedClone;
    private final String resourcePool;
    private final String cluster;
    private final String datastore;
    private final String folder;
    private final String customizationSpec;
    private final boolean powerOn;
    private final Integer timeoutInSeconds;
    private String IP;

    @DataBoundConstructor
    public Clone(String sourceName, String clone, boolean linkedClone, String resourcePool, String cluster, String datastore, String folder, boolean powerOn, Integer timeoutInSeconds, String customizationSpec) throws VSphereException {
        this.sourceName = sourceName;
        this.clone = clone;
        this.linkedClone = linkedClone;
        this.resourcePool = resourcePool;
        this.cluster = cluster;
        this.datastore = datastore;
        this.folder = folder;
        this.customizationSpec = customizationSpec;
        this.powerOn = powerOn;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getClone() {
        return this.clone;
    }

    public boolean isLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getCustomizationSpec() {
        return this.customizationSpec;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public int getTimeoutInSeconds() {
        if (this.timeoutInSeconds == null) {
            return 60;
        }
        return this.timeoutInSeconds;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.cloneFromSource(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public String getIP() {
        return this.IP;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws AbortException {
        boolean retVal = false;
        try {
            retVal = this.cloneFromSource((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            VSphereLogger.vsLogger(listener.getLogger(), "Error cloning VM or template\n" + sw.toString());
            try {
                sw.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AbortException(e.getMessage());
        }
        return retVal;
    }

    private boolean cloneFromSource(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedClone = this.clone;
        String expandedSource = this.sourceName;
        String expandedCluster = this.cluster;
        String expandedDatastore = this.datastore;
        String expandedFolder = this.folder;
        String expandedResourcePool = this.resourcePool;
        String expandedCustomizationSpec = this.customizationSpec;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedClone = env.expand(this.clone);
            expandedSource = env.expand(this.sourceName);
            expandedCluster = env.expand(this.cluster);
            expandedDatastore = env.expand(this.datastore);
            expandedFolder = env.expand(this.folder);
            expandedResourcePool = env.expand(this.resourcePool);
            expandedCustomizationSpec = env.expand(this.customizationSpec);
        }
        this.vsphere.cloneVm(expandedClone, expandedSource, this.linkedClone, expandedResourcePool, expandedCluster, expandedDatastore, expandedFolder, this.powerOn, expandedCustomizationSpec, jLogger);
        int timeoutInSecondsForGetIp = this.getTimeoutInSeconds();
        if (this.powerOn && timeoutInSecondsForGetIp > 0) {
            VSphereLogger.vsLogger(jLogger, "Powering on VM \"" + expandedClone + "\".  Waiting for its IP for the next " + timeoutInSecondsForGetIp + " seconds.");
            this.IP = this.vsphere.getIp(this.vsphere.getVmByName(expandedClone), timeoutInSecondsForGetIp);
        }
        VSphereLogger.vsLogger(jLogger, "\"" + expandedClone + "\" successfully cloned " + (this.powerOn ? "and powered on" : "") + "!");
        return true;
    }

    @Extension
    public static final class CloneDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public CloneDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_Clone();
        }

        public static int getDefaultTimeoutInSeconds() {
            return 60;
        }

        public FormValidation doCheckSource(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the sourceName name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClone(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the clone name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value, @QueryParameter String serverName, @QueryParameter String sourceName) throws IOException, ServletException {
            try {
                if (serverName == null) {
                    return FormValidation.error((String)Messages.validation_required("serverName"));
                }
                VSphere vsphere = CloneDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                VirtualMachine virtualMachine = vsphere.getVmByName(sourceName);
                if (virtualMachine == null) {
                    return FormValidation.error((String)("The source VM \"" + sourceName + "\"was not found cannot check the configuration."));
                }
                if (virtualMachine.getConfig().template && value.length() == 0) {
                    return FormValidation.error((String)Messages.validation_required("the resource pool"));
                }
            }
            catch (VSphereException ve) {
                return FormValidation.error((String)("Cannot connect to vsphere. " + ve.getMessage()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCustomizationSpec(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeoutInSeconds(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String sourceName, @QueryParameter String clone, @QueryParameter String resourcePool, @QueryParameter String cluster, @QueryParameter String customizationSpec) {
            try {
                if (sourceName.length() == 0 || clone.length() == 0 || serverName.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = CloneDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                VirtualMachine cloneVM = vsphere.getVmByName(clone);
                if (cloneVM != null) {
                    return FormValidation.error((String)Messages.validation_exists("clone"));
                }
                if (sourceName.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("sourceName"));
                }
                VirtualMachine vm = vsphere.getVmByName(sourceName);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("sourceName"));
                }
                VirtualMachineSnapshot snap = vm.getCurrentSnapShot();
                if (snap == null) {
                    return FormValidation.error((String)Messages.validation_noSnapshots());
                }
                if (customizationSpec != null && customizationSpec.length() > 0 && vsphere.getCustomizationSpecByName(customizationSpec) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("customizationSpec"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

