/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class vSphereCloudProvisionedSlave
extends vSphereCloudSlave {
    @DataBoundConstructor
    public vSphereCloudProvisionedSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, delegateLauncher, retentionStrategy, nodeProperties, vsDescription, vmName, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption, LimitedTestRunCount);
    }

    @Override
    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        vSphereCloud cloud;
        super._terminate(listener);
        vSphereCloudLauncher launcher = (vSphereCloudLauncher)this.getLauncher();
        if (launcher != null && (cloud = launcher.findOurVsInstance()) != null) {
            String cloneName = this.getComputer().getName();
            cloud.provisionedSlaveHasTerminated(cloneName);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave created from a vSphere Cloud slave template";
        }

        public boolean isInstantiable() {
            return false;
        }

        public List<vSphereCloud> getvSphereClouds() {
            ArrayList<vSphereCloud> result = new ArrayList<vSphereCloud>();
            for (Cloud cloud : Jenkins.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud)) continue;
                result.add((vSphereCloud)cloud);
            }
            return result;
        }

        public vSphereCloud getSpecificvSphereCloud(String vsDescription) throws Exception {
            for (vSphereCloud vs : this.getvSphereClouds()) {
                if (!vs.getVsDescription().equals(vsDescription)) continue;
                return vs;
            }
            throw new Exception("The vSphere Cloud doesn't exist");
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (vSphereCloudLauncher.class.isAssignableFrom(launcher.clazz)) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public List<String> getIdleOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("Shutdown");
            options.add("Shutdown and Revert");
            options.add("Revert and Restart");
            options.add("Revert and Reset");
            options.add("Suspend");
            options.add("Reset");
            options.add("Nothing");
            return options;
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doTestConnection(@QueryParameter String vsDescription, @QueryParameter String vmName, @QueryParameter String snapName) {
            try {
                VirtualMachineSnapshot snap;
                vSphereCloud vsC = this.getSpecificvSphereCloud(vsDescription);
                VirtualMachine vm = vsC.vSphereInstance().getVmByName(vmName);
                if (vm == null) {
                    return FormValidation.error((String)"Virtual Machine was not found");
                }
                if (!snapName.isEmpty() && (snap = vsC.vSphereInstance().getSnapshotInTree(vm, snapName)) == null) {
                    return FormValidation.error((String)"Virtual Machine snapshot was not found");
                }
                return FormValidation.ok((String)"Virtual Machine found successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Extension
    public static class vSphereCloudComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof vSphereCloudProvisionedSlave)) {
                return;
            }
            vSphereCloudLauncher vsL = (vSphereCloudLauncher)((SlaveComputer)c).getLauncher();
            vSphereCloud vsC = vsL.findOurVsInstance();
            if (!vsC.markVMOnline(c.getDisplayName(), vsL.getVmName()).booleanValue()) {
                throw new AbortException("The vSphere cloud will not allow this slave to start at this time.");
            }
        }
    }
}

