/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow;

import com.google.inject.Inject;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Map;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStepContainer;
import org.jenkinsci.plugins.vsphere.builders.ExposeGuestInfo;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class vSphereStep
extends AbstractStepImpl {
    private String serverName;
    private VSphereBuildStep buildStep;

    public String getServerName() {
        return this.serverName;
    }

    public VSphereBuildStep getBuildStep() {
        return this.buildStep;
    }

    @DataBoundConstructor
    public vSphereStep() {
    }

    @DataBoundSetter
    public void setBuildStep(VSphereBuildStep buildStep) {
        this.buildStep = buildStep;
    }

    @DataBoundSetter
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public static final class vSphereExecution
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        private transient VSphereBuildStepContainer vSphereBSC;
        @Inject
        private transient vSphereStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient FilePath filePath;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars envVars;

        protected String run() throws Exception {
            String IP = "";
            this.vSphereBSC = new VSphereBuildStepContainer(this.step.getBuildStep(), this.step.getServerName());
            this.vSphereBSC.perform(this.run, this.filePath, this.launcher, this.listener);
            if (this.step.getBuildStep().getClass().toString().contains("PowerOn") || this.step.getBuildStep().getClass().toString().contains("Deploy") || this.step.getBuildStep().getClass().toString().contains("Clone") || this.step.getBuildStep().getClass().toString().contains("ExposeGuestInfo")) {
                IP = this.step.getBuildStep().getIP();
                this.envVars.put("VSPHERE_IP", IP);
                if (this.step.getBuildStep().getClass().toString().contains("ExposeGuestInfo")) {
                    Map<String, String> envVars = ((ExposeGuestInfo)this.step.getBuildStep()).getVars();
                    for (Map.Entry<String, String> envVar : envVars.entrySet()) {
                        envVars.put(envVar.getKey(), envVar.getValue());
                    }
                }
            }
            this.vSphereBSC = null;
            return IP;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(vSphereExecution.class);
        }

        public String getFunctionName() {
            return "vSphere";
        }

        public String getDisplayName() {
            return "Invoke an vSphere action, exposing the VM IP under some actions";
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel select = new ListBoxModel();
            try {
                boolean hasVsphereClouds = false;
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof vSphereCloud)) continue;
                    hasVsphereClouds = true;
                    select.add(((vSphereCloud)cloud).getVsDescription());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return select;
        }

        public DescriptorExtensionList<VSphereBuildStep, VSphereBuildStep.VSphereBuildStepDescriptor> getBuildSteps() {
            return Hudson.getInstance().getDescriptorList(VSphereBuildStep.class);
        }
    }
}

