/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RenameSnapshot
extends VSphereBuildStep {
    private final String vm;
    private final String oldName;
    private final String newName;
    private final String newDescription;

    @DataBoundConstructor
    public RenameSnapshot(String vm, String oldName, String newName, String newDescription) throws VSphereException {
        this.vm = vm;
        this.oldName = oldName;
        this.newName = newName;
        this.newDescription = newDescription;
    }

    public String getVm() {
        return this.vm;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        String expandedOldName = env.expand(this.oldName);
        String expandedNewName = env.expand(this.newName);
        String expandedNewDescription = env.expand(this.newDescription);
        VSphereLogger.vsLogger(jLogger, "Renaming snapshot of VM \"" + expandedVm + "\" from \"" + expandedOldName + "\" to \"" + expandedNewName + "\" with description \"" + expandedNewDescription + "\". Please wait ...");
        this.vsphere.renameVmSnapshot(expandedVm, expandedOldName, expandedNewName, expandedNewDescription);
        VSphereLogger.vsLogger(jLogger, "Renamed!");
        return true;
    }

    @Extension
    public static final class RenameSnapshotDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public RenameSnapshotDescriptor() {
            this.load();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOldName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM snapshot name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_RenameSnapshot();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm, @QueryParameter String oldName, @QueryParameter String newName) {
            try {
                if (serverName.length() == 0 || oldName.length() == 0 || newName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = RenameSnapshotDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

