/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToVm
extends VSphereBuildStep {
    private final String template;
    private final String resourcePool;
    private final String cluster;

    @DataBoundConstructor
    public ConvertToVm(String template, String resourcePool, String cluster) throws VSphereException {
        this.template = template;
        this.resourcePool = resourcePool;
        this.cluster = cluster;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        return this.convert(build, launcher, listener);
    }

    private boolean convert(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Converting template to VM. Please wait ...");
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedTemplate = env.expand(this.template);
        this.vsphere.markAsVm(expandedTemplate, this.resourcePool, this.cluster);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedTemplate + "\" is a VM!");
        return true;
    }

    @Extension
    public static final class ConvertToVmDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public ConvertToVmDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_ConvertToVM();
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the Template name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the resource pool"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String template, @QueryParameter String resourcePool, @QueryParameter String cluster) {
            try {
                if (serverName.length() == 0 || template.length() == 0 || resourcePool.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (template.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("Template"));
                }
                VSphere vsphere = ConvertToVmDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("template"));
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_alreadySet("template", "VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

