/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TakeSnapshot
extends VSphereBuildStep {
    private final String vm;
    private final String snapshotName;
    private final String description;
    private final boolean includeMemory;

    @DataBoundConstructor
    public TakeSnapshot(String vm, String snapshotName, String description, boolean includeMemory) throws VSphereException {
        this.vm = vm;
        this.snapshotName = snapshotName;
        this.description = description;
        this.includeMemory = includeMemory;
    }

    public String getVm() {
        return this.vm;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIncludeMemory() {
        return this.includeMemory;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        boolean success = false;
        try {
            success = this.takeSnapshot(build, launcher, listener);
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
        }
        return success;
    }

    private boolean takeSnapshot(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        VSphereLogger.vsLogger(jLogger, "Taking snapshot...");
        this.vsphere.takeSnapshot(env.expand(this.vm), env.expand(this.snapshotName), env.expand(this.description), this.includeMemory);
        VSphereLogger.vsLogger(jLogger, "Complete.");
        return true;
    }

    @Extension
    public static class TakeSnapshotDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_TakeSnapshot();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSnapshotName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the snapshot name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDescription(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the Description"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm, @QueryParameter String snapshotName) {
            try {
                if (vm.length() == 0 || serverName.length() == 0 || snapshotName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = TakeSnapshotDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                if (vsphere.getVmByName(vm) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

