/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSpherePlugin;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkVM
extends Builder {
    private final String template;
    private final boolean powerOn;
    private final String serverName;
    private final int serverHash;
    private VSphere vsphere = null;

    @DataBoundConstructor
    public MarkVM(String serverName, String template, boolean powerOn) throws VSphereException {
        this.serverName = serverName;
        this.powerOn = powerOn;
        this.template = template;
        this.serverHash = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).getHash();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, Messages.console_usingServerConfig(this.serverName));
        boolean changed = false;
        try {
            this.vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByHash(this.serverHash).vSphereInstance();
            changed = this.markVm(build, launcher, listener);
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
            e.printStackTrace(jLogger);
        }
        return changed;
    }

    private boolean markVm(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Converting template to VM. Please wait ...");
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedTemplate = env.expand(this.template);
        VirtualMachine vm = this.vsphere.markAsVm(expandedTemplate);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedTemplate + "\" is a VM!");
        if (this.powerOn) {
            this.vsphere.startVm(expandedTemplate);
            String vmIP = this.vsphere.getIp(vm);
            if (vmIP != null) {
                VSphereLogger.vsLogger(jLogger, "Got IP for \"" + expandedTemplate + "\" ");
                VSphereEnvAction envAction = new VSphereEnvAction();
                envAction.add("VSPHERE_IP", vmIP);
                build.addAction((Action)envAction);
                return true;
            }
            VSphereLogger.vsLogger(jLogger, "Error: Could not get IP for \"" + expandedTemplate + "\" ");
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return VSphere.vSphereOutput(Messages.vm_title_MarkVM());
        }

        public FormValidation doCheckTemplate(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the Template name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String template) {
            try {
                if (serverName.length() == 0 || template.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).vSphereInstance();
                if (template.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("Template"));
                }
                VirtualMachine vm = vsphere.getVmByName(template);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("template"));
                }
                if (!vm.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_alreadySet("template", "VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillServerNameItems() {
            return VSpherePlugin.DescriptorImpl.get().doFillServerItems();
        }
    }
}

